/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp.wap;

import PduParser.GenericPdu;
import PduParser.NotificationInd;
import PduParser.PduParser;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.zx.sms.LongSMSMessage;
import com.zx.sms.codec.cmpp.wap.FrameHolder;
import com.zx.sms.codec.cmpp.wap.InformationElement;
import com.zx.sms.codec.cmpp.wap.LongMessageFrame;
import com.zx.sms.codec.cmpp.wap.SmsMessageHolder;
import com.zx.sms.codec.cmpp.wap.WspTypeDecoder;
import com.zx.sms.common.NotSupportedException;
import com.zx.sms.common.util.CMPPCommonUtil;
import com.zx.sms.common.util.StandardCharsets;
import es.rickyepoderi.wbxml.definition.WbXmlInitialization;
import es.rickyepoderi.wbxml.stream.WbXmlInputFactory;
import io.netty.buffer.ByteBufUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stax.StAXSource;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.marre.sms.SmsAlphabet;
import org.marre.sms.SmsDcs;
import org.marre.sms.SmsException;
import org.marre.sms.SmsMessage;
import org.marre.sms.SmsPdu;
import org.marre.sms.SmsPduUtil;
import org.marre.sms.SmsPort;
import org.marre.sms.SmsPortAddressedTextMessage;
import org.marre.sms.SmsSimTookitSecurityMessage;
import org.marre.sms.SmsTextMessage;
import org.marre.sms.SmsUdhIei;
import org.marre.sms.SmsUserData;
import org.marre.wap.push.SmsMmsNotificationMessage;
import org.marre.wap.push.SmsWapPushMessage;
import org.marre.wap.push.WapSIPush;
import org.marre.wap.push.WapSLPush;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public enum LongMessageFrameHolder {
    INS;

    private static final Logger logger;
    private static final RemovalListener<String, FrameHolder> removealListener;
    private static Cache<String, FrameHolder> cache;
    private static ConcurrentMap<String, FrameHolder> map;

    static {
        logger = LoggerFactory.getLogger(LongMessageFrameHolder.class);
        removealListener = new RemovalListener<String, FrameHolder>(){

            public void onRemoval(RemovalNotification<String, FrameHolder> notification) {
                RemovalCause cause = notification.getCause();
                FrameHolder h = (FrameHolder)notification.getValue();
                switch (cause) {
                    case COLLECTED: 
                    case EXPIRED: 
                    case SIZE: {
                        logger.error("Long Message Lost cause by {}. {}|{}|{}|{}", new Object[]{cause, DateFormatUtils.format((long)h.getTimestamp(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern()), notification.getKey(), h.getSequence(), LongMessageFrameHolder.buildTextMessage(h.mergeAllcontent(), h.getMsgfmt()).getText()});
                    }
                }
            }
        };
        cache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).removalListener(removealListener).build();
        map = cache.asMap();
    }

    private SmsMessage generatorSmsMessage(FrameHolder fh, LongMessageFrame frame) throws NotSupportedException {
        byte[] contents = fh.mergeAllcontent();
        InformationElement udheader = fh.getAppUDHinfo();
        if (udheader == null) {
            return LongMessageFrameHolder.buildTextMessage(contents, frame.getMsgfmt());
        }
        if (SmsUdhIei.APP_PORT_16BIT.equals(udheader.udhIei)) {
            int destport = ((udheader.infoEleData[0] & 0xFF) << 8 | udheader.infoEleData[1] & 0xFF) & 0xFFFF;
            int srcport = ((udheader.infoEleData[2] & 0xFF) << 8 | udheader.infoEleData[3] & 0xFF) & 0xFFFF;
            if (destport == SmsPort.WAP_PUSH.getPort() && srcport == SmsPort.WAP_WSP.getPort()) {
                return this.parseWapPdu(contents);
            }
            if (destport == SmsPort.NOKIA_MULTIPART_MESSAGE.getPort() && srcport == SmsPort.ZERO.getPort()) {
                throw new NotSupportedException("Nokia\u624b\u673a\u652f\u6301\u7684OTA\u56fe\u7247\u683c\u5f0f,\u65e0\u6cd5\u89e3\u6790");
            }
            if (destport == SmsPort.OTA_SETTINGS_BROWSER.getPort()) {
                throw new NotSupportedException("Nokia\u624b\u673a\u652f\u6301\u7684OTA\u6d4f\u89c8\u5668\u4e66\u7b7e,\u65e0\u6cd5\u89e3\u6790");
            }
            logger.warn("UnsupportedportMessage UDH:0x{} udhdata:{},pdu:[{}]", new Object[]{ByteBufUtil.hexDump((byte[])new byte[]{udheader.udhIei.getValue()}), ByteBufUtil.hexDump((byte[])udheader.infoEleData), ByteBufUtil.hexDump((byte[])contents)});
            SmsTextMessage text = LongMessageFrameHolder.buildTextMessage(contents, frame.getMsgfmt());
            return new SmsPortAddressedTextMessage(new SmsPort(destport), new SmsPort(srcport), text);
        }
        if (frame.getTppid() == 127 && (SmsUdhIei.COMMAND_PACKET.equals(udheader.udhIei) || SmsUdhIei.COMMAND_RESPONSE_PACKET.equals(udheader.udhIei))) {
            SmsSimTookitSecurityMessage sts = new SmsSimTookitSecurityMessage(udheader.udhIei.getValue(), udheader.infoEleData, contents);
            return sts;
        }
        logger.warn("Unsupported UDH:0x{} udhdata:{},pdu:[{}]", new Object[]{ByteBufUtil.hexDump((byte[])new byte[]{udheader.udhIei.getValue()}), ByteBufUtil.hexDump((byte[])udheader.infoEleData), ByteBufUtil.hexDump((byte[])contents)});
        return LongMessageFrameHolder.buildTextMessage(contents, frame.getMsgfmt());
    }

    static SmsTextMessage buildTextMessage(byte[] bytes, SmsDcs msgfmt) {
        String text = null;
        switch (msgfmt.getAlphabet()) {
            case GSM: {
                text = SmsPduUtil.unencodedSeptetsToString(bytes);
                break;
            }
            default: {
                text = new String(bytes, CMPPCommonUtil.switchCharset(msgfmt.getAlphabet()));
            }
        }
        return new SmsTextMessage(text, msgfmt);
    }

    public String getPartTextMsg(LongMessageFrame frame) {
        if (frame.getTpudhi() == 0) {
            return LongMessageFrameHolder.buildTextMessage(frame.getPayloadbytes(0), frame.getMsgfmt()).getText();
        }
        if ((frame.getTpudhi() & 1) == 1 || (frame.getTpudhi() & 0x40) == 64) {
            UserDataHeader header = this.parseUserDataHeader(frame.getMsgContentBytes());
            byte[] payload = frame.getPayloadbytes(header.headerlength);
            return LongMessageFrameHolder.buildTextMessage(payload, frame.getMsgfmt()).getText();
        }
        return null;
    }

    public SmsMessageHolder putAndget(String serviceNum, LongSMSMessage msg) throws NotSupportedException {
        block10: {
            LongMessageFrame frame = msg.generateFrame();
            if (frame.getTpudhi() == 0) {
                SmsTextMessage smsmsg = LongMessageFrameHolder.buildTextMessage(frame.getPayloadbytes(0), frame.getMsgfmt());
                return new SmsMessageHolder(smsmsg, msg);
            }
            if ((frame.getTpudhi() & 1) == 1 || (frame.getTpudhi() & 0x40) == 64) {
                FrameHolder fh;
                block9: {
                    try {
                        fh = this.createFrameHolder(serviceNum, frame);
                        if (fh != null) break block9;
                        return null;
                    }
                    catch (Exception ex) {
                        logger.error("", (Throwable)ex);
                        return null;
                    }
                }
                if (fh.isComplete()) {
                    return new SmsMessageHolder(this.generatorSmsMessage(fh, frame), msg);
                }
                String mapKey = serviceNum + "." + fh.frameKey;
                FrameHolder oldframeHolder = map.putIfAbsent(mapKey, fh);
                if (oldframeHolder != null) {
                    this.mergeFrameHolder(oldframeHolder, frame);
                    oldframeHolder.getMsg().addFragment(msg);
                } else {
                    fh.setMsg(msg);
                    oldframeHolder = fh;
                }
                if (oldframeHolder.isComplete()) {
                    map.remove(mapKey);
                    return new SmsMessageHolder(this.generatorSmsMessage(oldframeHolder, frame), oldframeHolder.getMsg());
                }
                break block10;
            }
            throw new NotSupportedException("Not Support LongMsg.Tpudhi");
        }
        return null;
    }

    public List<LongMessageFrame> splitmsgcontent(SmsMessage content) throws SmsException {
        ArrayList<LongMessageFrame> result = new ArrayList<LongMessageFrame>();
        SmsPdu[] pdus = content.getPdus();
        int i = 1;
        SmsPdu[] smsPduArray = pdus;
        int n = pdus.length;
        int n2 = 0;
        while (n2 < n) {
            SmsPdu aMsgPdu = smsPduArray[n2];
            byte[] udh = aMsgPdu.getUserDataHeaders();
            LongMessageFrame frame = new LongMessageFrame();
            frame.setPktotal((short)pdus.length);
            frame.setPknumber((short)i++);
            frame.setMsgfmt(aMsgPdu.getDcs());
            frame.setTpudhi(udh != null ? (short)1 : 0);
            ByteArrayOutputStream btos = new ByteArrayOutputStream(200);
            frame.setMsgLength((short)this.encodePdu(aMsgPdu, btos));
            frame.setMsgContentBytes(btos.toByteArray());
            result.add(frame);
            ++n2;
        }
        return result;
    }

    private FrameHolder mergeFrameHolder(FrameHolder fh, LongMessageFrame frame) throws NotSupportedException {
        byte[] msgcontent = frame.getMsgContentBytes();
        UserDataHeader header = this.parseUserDataHeader(msgcontent);
        if (header.infoElement.size() > 0) {
            for (InformationElement udhi : header.infoElement) {
                if (SmsUdhIei.CONCATENATED_8BIT.equals(udhi.udhIei)) {
                    fh.merge(frame.getPayloadbytes(header.headerlength), udhi.infoEleData[2] - 1);
                    break;
                }
                if (!SmsUdhIei.CONCATENATED_16BIT.equals(udhi.udhIei)) continue;
                fh.merge(frame.getPayloadbytes(header.headerlength), udhi.infoEleData[3] - 1);
                break;
            }
            return fh;
        }
        throw new NotSupportedException("Not Support LongMsg");
    }

    private int byteToint(byte b) {
        return b & 0xFF;
    }

    private FrameHolder createFrameHolder(String serviceNum, LongMessageFrame frame) throws NotSupportedException {
        byte[] msgcontent = frame.getMsgContentBytes();
        UserDataHeader header = this.parseUserDataHeader(msgcontent);
        if (header.infoElement.size() > 0) {
            FrameHolder frameholder = null;
            InformationElement appudhinfo = null;
            int i = 0;
            int frameKey = 0;
            int frameIndex = 0;
            for (InformationElement udhi : header.infoElement) {
                if (SmsUdhIei.CONCATENATED_8BIT.equals(udhi.udhIei)) {
                    frameKey = udhi.infoEleData[i];
                    frameholder = new FrameHolder(frameKey, this.byteToint(udhi.infoEleData[++i]));
                    frameIndex = this.byteToint(udhi.infoEleData[i + 1]) - 1;
                    continue;
                }
                if (SmsUdhIei.CONCATENATED_16BIT.equals(udhi.udhIei)) {
                    frameKey = (udhi.infoEleData[i] & 0xFF) << 8 | udhi.infoEleData[i + 1] & 0xFF & 0xFFFF;
                    frameholder = new FrameHolder(frameKey, this.byteToint(udhi.infoEleData[i += 2]));
                    frameIndex = this.byteToint(udhi.infoEleData[i + 1]) - 1;
                    continue;
                }
                appudhinfo = udhi;
            }
            if (frameholder == null) {
                frameholder = new FrameHolder(0, 1);
            }
            frameholder.setAppUDHinfo(appudhinfo);
            frameholder.setMsgfmt(frame.getMsgfmt());
            frameholder.setSequence(frame.getSequence());
            frameholder.setServiceNum(serviceNum);
            frameholder.merge(frame.getPayloadbytes(header.headerlength), frameIndex);
            return frameholder;
        }
        throw new NotSupportedException("Not Support LongMsg");
    }

    private UserDataHeader parseUserDataHeader(byte[] pdu) {
        UserDataHeader udh = new UserDataHeader();
        udh.headerlength = pdu[0];
        udh.infoElement = new ArrayList<InformationElement>();
        int i = 1;
        while (i < udh.headerlength) {
            InformationElement t = new InformationElement();
            t.udhIei = SmsUdhIei.valueOf(pdu[i++]);
            t.infoEleLength = pdu[i++];
            t.infoEleData = new byte[t.infoEleLength];
            if (t.infoEleLength > 0) {
                System.arraycopy(pdu, i, t.infoEleData, 0, t.infoEleLength);
                i += t.infoEleLength;
            }
            udh.infoElement.add(t);
        }
        return udh;
    }

    public static byte[] octetStream2septetStream(byte[] octets) {
        int septetCount = 8 * octets.length / 7;
        byte[] septets = new byte[septetCount];
        int newIndex = septets.length - 1;
        while (newIndex >= 0) {
            int bit = 6;
            while (bit >= 0) {
                int oldBitIndex = newIndex * 7 + bit;
                if ((octets[oldBitIndex >>> 3] & 1 << (oldBitIndex & 7)) != 0) {
                    int n = newIndex;
                    septets[n] = (byte)(septets[n] | 1 << bit);
                }
                --bit;
            }
            --newIndex;
        }
        return septets;
    }

    public static int octetLengthfromseptetsLength(int septetLength) {
        return (int)Math.ceil((double)(septetLength * 7) / 8.0);
    }

    private SmsMessage parseWapPdu(byte[] pdu) {
        int binaryContentType;
        int headerStartIndex;
        WspTypeDecoder pduDecoder;
        int headerLength;
        int pduType;
        int transactionId;
        block32: {
            String mimeType;
            block31: {
                int index = 0;
                transactionId = pdu[index++] & 0xFF;
                pduType = pdu[index++] & 0xFF;
                headerLength = 0;
                if (pduType != 6 && pduType != 7) {
                    return null;
                }
                pduDecoder = new WspTypeDecoder(pdu);
                if (!pduDecoder.decodeUintvarInteger(index)) {
                    return null;
                }
                headerLength = (int)pduDecoder.getValue32();
                headerStartIndex = index += pduDecoder.getDecodedDataLength();
                if (!pduDecoder.decodeContentType(index)) {
                    return null;
                }
                mimeType = pduDecoder.getValueString();
                if (mimeType != null) break block31;
                binaryContentType = (int)pduDecoder.getValue32();
                switch (binaryContentType) {
                    case 74: {
                        mimeType = "application/vnd.oma.drm.rights+xml";
                        break block32;
                    }
                    case 75: {
                        mimeType = "application/vnd.oma.drm.rights+wbxml";
                        break block32;
                    }
                    case 46: {
                        mimeType = "application/vnd.wap.sic";
                        break block32;
                    }
                    case 48: {
                        mimeType = "application/vnd.wap.slc";
                        break block32;
                    }
                    case 50: {
                        mimeType = "application/vnd.wap.coc";
                        break block32;
                    }
                    case 62: {
                        mimeType = "application/vnd.wap.mms-message";
                        break block32;
                    }
                    case 784: {
                        mimeType = "application/vnd.docomo.pf";
                        break block32;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (mimeType.equals("application/vnd.oma.drm.rights+xml")) {
                binaryContentType = 74;
            } else if (mimeType.equals("application/vnd.oma.drm.rights+wbxml")) {
                binaryContentType = 75;
            } else if (mimeType.equals("application/vnd.wap.sic")) {
                binaryContentType = 46;
            } else if (mimeType.equals("application/vnd.wap.slc")) {
                binaryContentType = 48;
            } else if (mimeType.equals("application/vnd.wap.coc")) {
                binaryContentType = 50;
            } else if (mimeType.equals("application/vnd.wap.mms-message")) {
                binaryContentType = 62;
            } else if (mimeType.equals("application/vnd.docomo.pf")) {
                binaryContentType = 784;
            } else {
                return null;
            }
        }
        index += pduDecoder.getDecodedDataLength();
        switch (binaryContentType) {
            case 46: {
                return this.dispatchWapPdu_PushWBXML(pdu, transactionId, pduType, headerStartIndex, headerLength, XMLFact.SIinFact);
            }
            case 48: {
                return this.dispatchWapPdu_PushWBXML(pdu, transactionId, pduType, headerStartIndex, headerLength, XMLFact.SLinFact);
            }
            case 62: {
                return this.dispatchWapPdu_MMS(pdu, transactionId, pduType, headerStartIndex, headerLength);
            }
        }
        return null;
    }

    private SmsMessage dispatchWapPdu_PushWBXML(byte[] pdu, int transactionId, int pduType, int headerStartIndex, int headerLength, XMLInputFactory inFact) {
        byte[] header = new byte[headerLength];
        System.arraycopy(pdu, headerStartIndex, header, 0, header.length);
        int dataIndex = headerStartIndex + headerLength;
        byte[] data = new byte[pdu.length - dataIndex];
        System.arraycopy(pdu, dataIndex, data, 0, data.length);
        try {
            Node uri;
            NamedNodeMap attrs;
            Document doc = this.wbxmlStream2Doc(inFact, new ByteArrayInputStream(data), false);
            Node node = doc.getFirstChild();
            if ("si".equals(node.getNodeName())) {
                NodeList nl = node.getChildNodes();
                if (nl != null && nl.getLength() > 0) {
                    int index = 0;
                    while (index < nl.getLength()) {
                        Node uri2;
                        NamedNodeMap attrs2;
                        Node indication = nl.item(index);
                        if ("indication".equals(indication.getNodeName()) && (attrs2 = indication.getAttributes()) != null && (uri2 = attrs2.getNamedItem("href")) != null) {
                            String uriStr = uri2.getNodeValue();
                            Node message = indication.getFirstChild();
                            String text = message != null ? message.getNodeValue() : "";
                            WapSIPush si = new WapSIPush(uriStr, text);
                            return new SmsWapPushMessage(si);
                        }
                        ++index;
                    }
                }
            } else if ("sl".equals(node.getNodeName()) && (attrs = node.getAttributes()) != null && (uri = attrs.getNamedItem("href")) != null) {
                String uriStr = uri.getNodeValue();
                WapSLPush sl = new WapSLPush(uriStr);
                return new SmsWapPushMessage(sl);
            }
        }
        catch (Exception e) {
            logger.error("pdu = [{}]", (Object)ByteBufUtil.hexDump((byte[])pdu));
        }
        return null;
    }

    private SmsMessage dispatchWapPdu_MMS(byte[] pdu, int transactionId, int pduType, int headerStartIndex, int headerLength) {
        byte[] header = new byte[headerLength];
        System.arraycopy(pdu, headerStartIndex, header, 0, header.length);
        int dataIndex = headerStartIndex + headerLength;
        byte[] data = new byte[pdu.length - dataIndex];
        System.arraycopy(pdu, dataIndex, data, 0, data.length);
        PduParser parse = new PduParser(data);
        GenericPdu notify = parse.parse();
        if (notify != null && notify instanceof NotificationInd) {
            String msgclass;
            NotificationInd nind = (NotificationInd)notify;
            SmsMmsNotificationMessage mms = new SmsMmsNotificationMessage(new String(nind.getContentLocation(), StandardCharsets.US_ASCII), nind.getMessageSize());
            mms.setExpiry((int)(nind.getExpiry() - System.currentTimeMillis() / 1000L));
            if (nind.getFrom() != null) {
                mms.setFrom(nind.getFrom().getString());
            }
            if ("personal".equals(msgclass = new String(nind.getMessageClass(), StandardCharsets.UTF_8))) {
                mms.setMessageClass(0);
            } else if ("advertisement".equals(msgclass)) {
                mms.setMessageClass(1);
            } else if ("auto".equals(msgclass)) {
                mms.setMessageClass(3);
            } else if ("informational".equals(msgclass)) {
                mms.setMessageClass(2);
            }
            if (nind.getSubject() != null) {
                mms.setSubject(nind.getSubject().getString());
            }
            if (nind.getTransactionId() != null) {
                mms.setTransactionId(new String(nind.getTransactionId()));
            }
            return mms;
        }
        return null;
    }

    protected Document wbxmlStream2Doc(XMLInputFactory inFact, InputStream in, boolean event) throws Exception {
        XMLStreamReader xmlStreamReader = null;
        XMLEventReader xmlEventReader = null;
        try {
            if (event) {
                xmlEventReader = inFact.createXMLEventReader(in);
            } else {
                xmlStreamReader = inFact.createXMLStreamReader(in);
            }
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            StAXSource staxSource = event ? new StAXSource(xmlEventReader) : new StAXSource(xmlStreamReader);
            DOMResult domResult = new DOMResult();
            xformer.transform(staxSource, domResult);
            Document doc = (Document)domResult.getNode();
            doc.normalize();
            Document document = doc;
            return document;
        }
        finally {
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (Exception exception) {}
            }
            if (xmlEventReader != null) {
                try {
                    xmlEventReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private int encodePdu(SmsPdu pdu, OutputStream baos) throws SmsException {
        switch (pdu.getDcs().getAlphabet()) {
            case GSM: {
                return LongMessageFrameHolder.encodeSeptetPdu(pdu, baos);
            }
        }
        return LongMessageFrameHolder.encodeOctetPdu(pdu, baos);
    }

    public static int getPayloadLength(SmsAlphabet alpha, int udl) {
        switch (alpha) {
            case GSM: {
                return LongMessageFrameHolder.octetLengthfromseptetsLength(udl);
            }
        }
        return udl;
    }

    private static int encodeSeptetPdu(SmsPdu pdu, OutputStream baos) throws SmsException {
        SmsUserData userData = pdu.getUserData();
        byte[] ud = userData.getData();
        byte[] udh = pdu.getUserDataHeaders();
        int nUdSeptets = ud.length * 8 / 7;
        int nUdBits = 0;
        int nUdhBytes = udh == null ? 0 : udh.length;
        int nUdhBits = 0;
        int nTotalBytes = 0;
        int nTotalBits = 0;
        int nTotalSeptets = 0;
        int nFillBits = 0;
        int length = 0;
        try {
            nUdhBits = nUdhBytes * 8;
            nUdBits = nUdSeptets * 7;
            nTotalBits = nUdBits + nFillBits + nUdhBits;
            nTotalSeptets = nTotalBits / 7;
            nTotalBytes = nTotalBits / 8;
            if (nTotalBits % 8 > 0) {
                ++nTotalBytes;
            }
            if (udh == null || udh.length == 0) {
                length = nUdSeptets;
                baos.write(ud);
            } else {
                byte[] fullUd = new byte[nTotalBytes];
                length = nTotalSeptets;
                System.arraycopy(udh, 0, fullUd, 0, nUdhBytes);
                SmsPduUtil.arrayCopy(ud, 0, fullUd, nUdhBytes, nFillBits, nUdBits);
                baos.write(fullUd);
            }
            baos.close();
        }
        catch (IOException ex) {
            throw new SmsException(ex);
        }
        return length;
    }

    private static int encodeOctetPdu(SmsPdu pdu, OutputStream baos) throws SmsException {
        SmsUserData userData = pdu.getUserData();
        byte[] ud = userData.getData();
        byte[] udh = pdu.getUserDataHeaders();
        int length = 0;
        try {
            int nUdhBytes;
            int nUdBytes = userData.getLength();
            int n = nUdhBytes = udh == null ? 0 : udh.length;
            if (nUdhBytes == 0) {
                length = nUdBytes;
                baos.write(ud);
            } else {
                length = nUdBytes + nUdhBytes;
                baos.write(udh);
                baos.write(ud);
            }
            baos.close();
        }
        catch (IOException ex) {
            throw new SmsException(ex);
        }
        return length;
    }

    private class UserDataHeader {
        int headerlength;
        List<InformationElement> infoElement;

        private UserDataHeader() {
        }
    }

    private static enum XMLFact {
        INS;

        private static final XMLInputFactory SLinFact;
        private static final XMLInputFactory SIinFact;

        static {
            SLinFact = XMLFact.createSLinFact();
            SIinFact = XMLFact.createSIinFact();
        }

        private static XMLInputFactory createSLinFact() {
            WbXmlInputFactory inFact = new WbXmlInputFactory();
            ((XMLInputFactory)inFact).setProperty(WbXmlInputFactory.DEFINITION_PROPERTY, WbXmlInitialization.getDefinitionByName("SL 1.0"));
            return inFact;
        }

        private static XMLInputFactory createSIinFact() {
            WbXmlInputFactory inFact = new WbXmlInputFactory();
            ((XMLInputFactory)inFact).setProperty(WbXmlInputFactory.DEFINITION_PROPERTY, WbXmlInitialization.getDefinitionByName("SI 1.0"));
            return inFact;
        }
    }
}

