/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp.wap;

public class WspTypeDecoder {
    private static final int WAP_PDU_SHORT_LENGTH_MAX = 30;
    private static final int WAP_PDU_LENGTH_QUOTE = 31;
    public static final int PDU_TYPE_PUSH = 6;
    public static final int PDU_TYPE_CONFIRMED_PUSH = 7;
    public static final int CONTENT_TYPE_B_DRM_RIGHTS_XML = 74;
    public static final int CONTENT_TYPE_B_DRM_RIGHTS_WBXML = 75;
    public static final int CONTENT_TYPE_B_PUSH_SI = 46;
    public static final int CONTENT_TYPE_B_PUSH_SL = 48;
    public static final int CONTENT_TYPE_B_PUSH_CO = 50;
    public static final int CONTENT_TYPE_B_MMS = 62;
    public static final int CONTENT_TYPE_B_VND_DOCOMO_PF = 784;
    public static final String CONTENT_MIME_TYPE_B_DRM_RIGHTS_XML = "application/vnd.oma.drm.rights+xml";
    public static final String CONTENT_MIME_TYPE_B_DRM_RIGHTS_WBXML = "application/vnd.oma.drm.rights+wbxml";
    public static final String CONTENT_MIME_TYPE_B_PUSH_SI = "application/vnd.wap.sic";
    public static final String CONTENT_MIME_TYPE_B_PUSH_SL = "application/vnd.wap.slc";
    public static final String CONTENT_MIME_TYPE_B_PUSH_CO = "application/vnd.wap.coc";
    public static final String CONTENT_MIME_TYPE_B_MMS = "application/vnd.wap.mms-message";
    public static final String CONTENT_MIME_TYPE_B_VND_DOCOMO_PF = "application/vnd.docomo.pf";
    public static final int PARAMETER_ID_X_WAP_APPLICATION_ID = 47;
    byte[] wspData;
    int dataLength;
    long unsigned32bit;
    String stringValue;

    public WspTypeDecoder(byte[] pdu) {
        this.wspData = pdu;
    }

    public boolean decodeTextString(int startIndex) {
        int index = startIndex;
        while (this.wspData[index] != 0) {
            ++index;
        }
        this.dataLength = index - startIndex + 1;
        this.stringValue = this.wspData[startIndex] == 127 ? new String(this.wspData, startIndex + 1, this.dataLength - 2) : new String(this.wspData, startIndex, this.dataLength - 1);
        return true;
    }

    public boolean decodeShortInteger(int startIndex) {
        if ((this.wspData[startIndex] & 0x80) == 0) {
            return false;
        }
        this.unsigned32bit = this.wspData[startIndex] & 0x7F;
        this.dataLength = 1;
        return true;
    }

    public boolean decodeLongInteger(int startIndex) {
        int lengthMultiOctet = this.wspData[startIndex] & 0xFF;
        if (lengthMultiOctet > 30) {
            return false;
        }
        this.unsigned32bit = 0L;
        int i = 1;
        while (i <= lengthMultiOctet) {
            this.unsigned32bit = this.unsigned32bit << 8 | (long)(this.wspData[startIndex + i] & 0xFF);
            ++i;
        }
        this.dataLength = 1 + lengthMultiOctet;
        return true;
    }

    public boolean decodeIntegerValue(int startIndex) {
        if (this.decodeShortInteger(startIndex)) {
            return true;
        }
        return this.decodeLongInteger(startIndex);
    }

    public boolean decodeUintvarInteger(int startIndex) {
        int index = startIndex;
        this.unsigned32bit = 0L;
        while ((this.wspData[index] & 0x80) != 0) {
            if (index - startIndex >= 4) {
                return false;
            }
            this.unsigned32bit = this.unsigned32bit << 7 | (long)(this.wspData[index] & 0x7F);
            ++index;
        }
        this.unsigned32bit = this.unsigned32bit << 7 | (long)(this.wspData[index] & 0x7F);
        this.dataLength = index - startIndex + 1;
        return true;
    }

    public boolean decodeValueLength(int startIndex) {
        if ((this.wspData[startIndex] & 0xFF) > 31) {
            return false;
        }
        if (this.wspData[startIndex] < 31) {
            this.unsigned32bit = this.wspData[startIndex];
            this.dataLength = 1;
        } else {
            this.decodeUintvarInteger(startIndex + 1);
            ++this.dataLength;
        }
        return true;
    }

    public boolean decodeExtensionMedia(int startIndex) {
        int index = startIndex;
        this.dataLength = 0;
        this.stringValue = null;
        int length = this.wspData.length;
        boolean rtrn = index < length;
        while (index < length && this.wspData[index] != 0) {
            ++index;
        }
        this.dataLength = index - startIndex + 1;
        this.stringValue = new String(this.wspData, startIndex, this.dataLength - 1);
        return rtrn;
    }

    public boolean decodeConstrainedEncoding(int startIndex) {
        if (this.decodeShortInteger(startIndex)) {
            this.stringValue = null;
            return true;
        }
        return this.decodeExtensionMedia(startIndex);
    }

    public boolean decodeContentType(int startIndex) {
        if (!this.decodeValueLength(startIndex)) {
            return this.decodeConstrainedEncoding(startIndex);
        }
        int mediaPrefixLength = this.getDecodedDataLength();
        long mediaFieldLength = this.getValue32();
        if (this.decodeIntegerValue(startIndex + mediaPrefixLength)) {
            this.dataLength += mediaPrefixLength;
            this.stringValue = null;
            return true;
        }
        if (this.decodeExtensionMedia(startIndex + mediaPrefixLength)) {
            this.dataLength += mediaPrefixLength;
            return true;
        }
        return false;
    }

    public boolean decodeContentLength(int startIndex) {
        return this.decodeIntegerValue(startIndex);
    }

    public boolean decodeContentLocation(int startIndex) {
        return this.decodeTextString(startIndex);
    }

    public boolean decodeXWapApplicationId(int startIndex) {
        if (this.decodeIntegerValue(startIndex)) {
            this.stringValue = null;
            return true;
        }
        return this.decodeTextString(startIndex);
    }

    public boolean decodeXWapContentURI(int startIndex) {
        return this.decodeTextString(startIndex);
    }

    public boolean decodeXWapInitiatorURI(int startIndex) {
        return this.decodeTextString(startIndex);
    }

    public int getDecodedDataLength() {
        return this.dataLength;
    }

    public long getValue32() {
        return this.unsigned32bit;
    }

    public String getValueString() {
        return this.stringValue;
    }
}

