/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp20;

import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.cmpp20.packet.Cmpp20PacketType;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class CMPP20MessageCodecAggregator
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(CMPP20MessageCodecAggregator.class);
    private ConcurrentHashMap<Long, MessageToMessageCodec> codecMap = new ConcurrentHashMap();

    private CMPP20MessageCodecAggregator() {
        Cmpp20PacketType[] cmpp20PacketTypeArray = Cmpp20PacketType.values();
        int n = cmpp20PacketTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Cmpp20PacketType packetType = cmpp20PacketTypeArray[n2];
            this.codecMap.put(packetType.getCommandId(), packetType.getCodec());
            ++n2;
        }
    }

    public static CMPP20MessageCodecAggregator getInstance() {
        return CMPP20MessageCodecAggregatorHolder.instance;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        long commandId = ((Message)msg).getHeader().getCommandId();
        MessageToMessageCodec codec = this.codecMap.get(commandId);
        codec.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        try {
            long commandId = ((Message)msg).getHeader().getCommandId();
            MessageToMessageCodec codec = this.codecMap.get(commandId);
            codec.write(ctx, msg, promise);
        }
        catch (Exception ex) {
            promise.tryFailure((Throwable)ex);
        }
    }

    /* synthetic */ CMPP20MessageCodecAggregator(CMPP20MessageCodecAggregator cMPP20MessageCodecAggregator) {
        this();
    }

    private static class CMPP20MessageCodecAggregatorHolder {
        private static final CMPP20MessageCodecAggregator instance = new CMPP20MessageCodecAggregator(null);

        private CMPP20MessageCodecAggregatorHolder() {
        }
    }
}

