/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp20;

import com.zx.sms.codec.cmpp.msg.CmppConnectResponseMessage;
import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.cmpp.packet.PacketType;
import com.zx.sms.codec.cmpp20.packet.Cmpp20ConnectResponse;
import com.zx.sms.codec.cmpp20.packet.Cmpp20PacketType;
import com.zx.sms.common.NotSupportedException;
import com.zx.sms.common.util.NettyByteBufUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.ReferenceCountUtil;
import java.util.List;

public class Cmpp20ConnectResponseMessageCodec
extends MessageToMessageCodec<Message, CmppConnectResponseMessage> {
    private PacketType packetType;

    public Cmpp20ConnectResponseMessageCodec() {
        this(Cmpp20PacketType.CMPPCONNECTRESPONSE);
    }

    public Cmpp20ConnectResponseMessageCodec(PacketType packetType) {
        this.packetType = packetType;
    }

    protected void decode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        long commandId = msg.getHeader().getCommandId();
        if (commandId != this.packetType.getCommandId()) {
            out.add(msg);
            return;
        }
        CmppConnectResponseMessage responseMessage = new CmppConnectResponseMessage(msg.getHeader());
        byte[] body = msg.getBodyBuffer();
        if (body.length != 18) {
            if (body.length == 21) {
                throw new NotSupportedException("error cmpp version . shoud use cmpp3.0 ");
            }
            throw new NotSupportedException("error cmpp CmppConnectResponseMessage data .");
        }
        ByteBuf bodyBuffer = Unpooled.wrappedBuffer((byte[])msg.getBodyBuffer());
        responseMessage.setStatus(bodyBuffer.readUnsignedByte());
        responseMessage.setAuthenticatorISMG(NettyByteBufUtil.toArray(bodyBuffer, Cmpp20ConnectResponse.AUTHENTICATORISMG.getLength()));
        responseMessage.setVersion(bodyBuffer.readUnsignedByte());
        ReferenceCountUtil.release((Object)bodyBuffer);
        out.add(responseMessage);
    }

    protected void encode(ChannelHandlerContext ctx, CmppConnectResponseMessage msg, List<Object> out) throws Exception {
        ByteBuf bodyBuffer = ctx.alloc().buffer(Cmpp20ConnectResponse.AUTHENTICATORISMG.getBodyLength());
        bodyBuffer.writeByte((int)msg.getStatus());
        bodyBuffer.writeBytes(msg.getAuthenticatorISMG());
        bodyBuffer.writeByte((int)msg.getVersion());
        msg.setBodyBuffer(NettyByteBufUtil.toArray(bodyBuffer, bodyBuffer.readableBytes()));
        msg.getHeader().setBodyLength(msg.getBodyBuffer().length);
        ReferenceCountUtil.release((Object)bodyBuffer);
        out.add(msg);
    }
}

