/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.cmpp7F;

import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.cmpp7F.packet.Cmpp7FPacketType;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class CMPP7FMessageCodecAggregator
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(CMPP7FMessageCodecAggregator.class);
    private ConcurrentHashMap<Long, MessageToMessageCodec> codecMap = new ConcurrentHashMap();

    private CMPP7FMessageCodecAggregator() {
        Cmpp7FPacketType[] cmpp7FPacketTypeArray = Cmpp7FPacketType.values();
        int n = cmpp7FPacketTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Cmpp7FPacketType packetType = cmpp7FPacketTypeArray[n2];
            this.codecMap.put(packetType.getCommandId(), packetType.getCodec());
            ++n2;
        }
    }

    public static CMPP7FMessageCodecAggregator getInstance() {
        return CMPP7FMessageCodecAggregatorHolder.instance;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        long commandId = ((Message)msg).getHeader().getCommandId();
        MessageToMessageCodec codec = this.codecMap.get(commandId);
        codec.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        try {
            long commandId = ((Message)msg).getHeader().getCommandId();
            MessageToMessageCodec codec = this.codecMap.get(commandId);
            codec.write(ctx, msg, promise);
        }
        catch (Exception ex) {
            promise.tryFailure((Throwable)ex);
        }
    }

    /* synthetic */ CMPP7FMessageCodecAggregator(CMPP7FMessageCodecAggregator cMPP7FMessageCodecAggregator) {
        this();
    }

    private static class CMPP7FMessageCodecAggregatorHolder {
        private static final CMPP7FMessageCodecAggregator instance = new CMPP7FMessageCodecAggregator(null);

        private CMPP7FMessageCodecAggregatorHolder() {
        }
    }
}

