/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.sgip12.codec;

import com.zx.sms.codec.cmpp.msg.DefaultHeader;
import com.zx.sms.codec.cmpp.msg.DefaultMessage;
import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.codec.sgip12.packet.SgipHead;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import com.zx.sms.common.util.SequenceNumber;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SgipHeaderCodec
extends MessageToMessageCodec<ByteBuf, Message> {
    private final Logger logger = LoggerFactory.getLogger(SgipHeaderCodec.class);

    protected void decode(ChannelHandlerContext ctx, ByteBuf bytebuf, List<Object> list) throws Exception {
        DefaultMessage message = new DefaultMessage();
        DefaultHeader header = new DefaultHeader();
        header.setPacketLength(bytebuf.readUnsignedInt());
        header.setCommandId(bytebuf.readUnsignedInt());
        byte[] seqbytes = new byte[SgipHead.SEQUENCENUMBER.getLength()];
        bytebuf.readBytes(seqbytes);
        SequenceNumber seq = DefaultSequenceNumberUtil.bytes2SequenceN(seqbytes);
        message.setTimestamp(seq.getTimestamp());
        header.setSequenceId(seq.getSequenceId());
        header.setNodeId(seq.getNodeIds());
        header.setHeadLength(SgipHead.COMMANDID.getHeadLength());
        header.setBodyLength(header.getPacketLength() - header.getHeadLength());
        if (header.getBodyLength() > 0L) {
            message.setBodyBuffer(new byte[(int)header.getBodyLength()]);
            assert (header.getBodyLength() == (long)bytebuf.readableBytes());
            bytebuf.readBytes(message.getBodyBuffer());
        } else {
            message.setBodyBuffer(GlobalConstance.emptyBytes);
        }
        message.setHeader(header);
        list.add(message);
    }

    protected void encode(ChannelHandlerContext ctx, Message message, List<Object> list) throws Exception {
        int headerLength = SgipHead.COMMANDID.getHeadLength();
        int packetLength = message.getBodyBuffer().length + headerLength;
        ByteBuf buf = ctx.alloc().buffer(packetLength);
        buf.writeInt(packetLength);
        buf.writeInt((int)message.getHeader().getCommandId());
        String timeString = DateFormatUtils.format((long)message.getTimestamp(), (String)"MMddHHmmss");
        buf.writeInt((int)message.getHeader().getNodeId());
        buf.writeInt(Integer.valueOf(timeString).intValue());
        buf.writeInt((int)message.getHeader().getSequenceId());
        if (packetLength > headerLength) {
            buf.writeBytes(message.getBodyBuffer());
        }
        list.add(buf);
    }
}

