/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.sgip12.msg;

import com.zx.sms.LongSMSMessage;
import com.zx.sms.codec.cmpp.msg.DefaultMessage;
import com.zx.sms.codec.cmpp.msg.Header;
import com.zx.sms.codec.cmpp.packet.PacketType;
import com.zx.sms.codec.cmpp.wap.LongMessageFrame;
import com.zx.sms.codec.cmpp.wap.LongMessageFrameHolder;
import com.zx.sms.codec.sgip12.packet.SgipPacketType;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.util.CMPPCommonUtil;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import java.util.ArrayList;
import java.util.List;
import org.marre.sms.SmsDcs;
import org.marre.sms.SmsMessage;

public class SgipDeliverRequestMessage
extends DefaultMessage
implements LongSMSMessage<SgipDeliverRequestMessage> {
    private static final long serialVersionUID = -605827022369453415L;
    private String usernumber = "";
    private String spnumber = "";
    private short tppid = 0;
    private short tpudhi = 0;
    private SmsDcs msgfmt = GlobalConstance.defaultmsgfmt;
    private int messagelength = 120;
    private String reserve = "";
    private byte[] msgContentBytes = GlobalConstance.emptyBytes;
    private SmsMessage msg;
    private List<SgipDeliverRequestMessage> fragments = null;

    public SgipDeliverRequestMessage() {
        super(SgipPacketType.DELIVERREQUEST);
    }

    public SgipDeliverRequestMessage(Header header) {
        super((PacketType)SgipPacketType.DELIVERREQUEST, header);
    }

    public SmsDcs getMsgfmt() {
        return this.msgfmt;
    }

    public void setMsgfmt(SmsDcs msgfmt) {
        this.msgfmt = msgfmt;
    }

    public String getUsernumber() {
        return this.usernumber;
    }

    public void setUsernumber(String usernumber) {
        this.usernumber = usernumber;
    }

    public String getSpnumber() {
        return this.spnumber;
    }

    public void setSpnumber(String spnumber) {
        this.spnumber = spnumber;
    }

    public short getTppid() {
        return this.tppid;
    }

    public void setTppid(short tppid) {
        this.tppid = tppid;
    }

    public short getTpudhi() {
        return this.tpudhi;
    }

    public void setTpudhi(short tpudhi) {
        this.tpudhi = tpudhi;
    }

    public int getMessagelength() {
        return this.messagelength;
    }

    public void setMessagelength(int messagelength) {
        this.messagelength = messagelength;
    }

    public String getReserve() {
        return this.reserve;
    }

    @Override
    public boolean isReport() {
        return false;
    }

    public void setReserve(String reserve) {
        this.reserve = reserve;
    }

    public String getMsgContent() {
        if (this.msg instanceof SmsMessage) {
            return this.msg.toString();
        }
        if (this.msgContentBytes != null && this.msgContentBytes.length > 0) {
            LongMessageFrame frame = this.generateFrame();
            return LongMessageFrameHolder.INS.getPartTextMsg(frame);
        }
        return "";
    }

    public void setMsgContent(String msgContent) {
        this.setMsgContent(CMPPCommonUtil.buildTextMessage(msgContent));
    }

    public void setMsgContent(SmsMessage msg) {
        this.msg = msg;
    }

    @Override
    public SmsMessage getSmsMessage() {
        return this.msg;
    }

    public byte[] getMsgContentBytes() {
        return this.msgContentBytes;
    }

    public void setMsgContentBytes(byte[] msgContentBytes) {
        this.msgContentBytes = msgContentBytes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SgipDeliverRequestMessage [").append("destId=").append(this.usernumber).append(", srcterminalId=").append(this.spnumber).append(", msgContent=").append(this.getMsgContent()).append(", header=").append(this.getHeader()).append("]");
        return sb.toString();
    }

    @Override
    public SgipDeliverRequestMessage clone() throws CloneNotSupportedException {
        return (SgipDeliverRequestMessage)super.clone();
    }

    @Override
    public LongMessageFrame generateFrame() {
        LongMessageFrame frame = new LongMessageFrame();
        frame.setTppid(this.getTppid());
        frame.setTpudhi(this.getTpudhi());
        frame.setMsgfmt(this.getMsgfmt());
        frame.setMsgContentBytes(this.getMsgContentBytes());
        frame.setMsgLength((short)this.getMessagelength());
        frame.setSequence(this.getSequenceNo());
        return frame;
    }

    @Override
    public SgipDeliverRequestMessage generateMessage(LongMessageFrame frame) throws Exception {
        SgipDeliverRequestMessage requestMessage = this.clone();
        requestMessage.setTpudhi(frame.getTpudhi());
        requestMessage.setMsgfmt(frame.getMsgfmt());
        requestMessage.setMsgContentBytes(frame.getMsgContentBytes());
        requestMessage.setMessagelength(frame.getMsgLength());
        if (frame.getPknumber() != 1) {
            requestMessage.getHeader().setSequenceId(DefaultSequenceNumberUtil.getSequenceNo());
        }
        requestMessage.setMsgContent((SmsMessage)null);
        return requestMessage;
    }

    @Override
    public List<SgipDeliverRequestMessage> getFragments() {
        return this.fragments;
    }

    @Override
    public void addFragment(SgipDeliverRequestMessage fragment) {
        if (this.fragments == null) {
            this.fragments = new ArrayList<SgipDeliverRequestMessage>();
        }
        this.fragments.add(fragment);
    }
}

