/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.sgip12.packet;

import com.zx.sms.codec.cmpp.packet.PacketStructure;
import com.zx.sms.codec.cmpp.packet.PacketType;
import com.zx.sms.codec.sgip12.codec.SgipBindRequestMessageCodec;
import com.zx.sms.codec.sgip12.codec.SgipBindResponseMessageCodec;
import com.zx.sms.codec.sgip12.codec.SgipDeliverRequestMessageCodec;
import com.zx.sms.codec.sgip12.codec.SgipDeliverResponseMessageCodec;
import com.zx.sms.codec.sgip12.codec.SgipReportRequestMessageCodec;
import com.zx.sms.codec.sgip12.codec.SgipReportResponseMessageCodec;
import com.zx.sms.codec.sgip12.codec.SgipSubmitRequestMessageCodec;
import com.zx.sms.codec.sgip12.codec.SgipSubmitResponseMessageCodec;
import com.zx.sms.codec.sgip12.codec.SgipUnbindRequestMessageCodec;
import com.zx.sms.codec.sgip12.codec.SgipUnbindResponseMessageCodec;
import com.zx.sms.codec.sgip12.packet.SgipBindRequest;
import com.zx.sms.codec.sgip12.packet.SgipBindResponse;
import com.zx.sms.codec.sgip12.packet.SgipDeliverRequest;
import com.zx.sms.codec.sgip12.packet.SgipDeliverResponse;
import com.zx.sms.codec.sgip12.packet.SgipReportRequest;
import com.zx.sms.codec.sgip12.packet.SgipReportResponse;
import com.zx.sms.codec.sgip12.packet.SgipSubmitRequest;
import com.zx.sms.codec.sgip12.packet.SgipSubmitResponse;
import com.zx.sms.codec.sgip12.packet.SgipUnbindRequest;
import com.zx.sms.codec.sgip12.packet.SgipUnbindResponse;
import io.netty.handler.codec.MessageToMessageCodec;

public enum SgipPacketType implements PacketType
{
    BINDREQUEST(1L, SgipBindRequest.class, SgipBindRequestMessageCodec.class),
    BINDRESPONSE(0x80000001L, SgipBindResponse.class, SgipBindResponseMessageCodec.class),
    UNBINDREQUEST(2L, SgipUnbindRequest.class, SgipUnbindRequestMessageCodec.class),
    UNBINDRESPONSE(0x80000002L, SgipUnbindResponse.class, SgipUnbindResponseMessageCodec.class),
    SUBMITREQUEST(3L, SgipSubmitRequest.class, SgipSubmitRequestMessageCodec.class),
    SUBMITRESPONSE(0x80000003L, SgipSubmitResponse.class, SgipSubmitResponseMessageCodec.class),
    DELIVERREQUEST(4L, SgipDeliverRequest.class, SgipDeliverRequestMessageCodec.class),
    DELIVERRESPONSE(0x80000004L, SgipDeliverResponse.class, SgipDeliverResponseMessageCodec.class),
    REPORTREQUEST(5L, SgipReportRequest.class, SgipReportRequestMessageCodec.class),
    REPORTRESPONSE(0x80000005L, SgipReportResponse.class, SgipReportResponseMessageCodec.class);

    private long commandId;
    private Class<? extends PacketStructure> packetStructure;
    private Class<? extends MessageToMessageCodec> codec;

    private SgipPacketType(long commandId, Class<? extends PacketStructure> packetStructure, Class<? extends MessageToMessageCodec> codec) {
        this.commandId = commandId;
        this.packetStructure = packetStructure;
        this.codec = codec;
    }

    @Override
    public long getCommandId() {
        return this.commandId;
    }

    @Override
    public PacketStructure[] getPacketStructures() {
        return this.packetStructure.getEnumConstants();
    }

    @Override
    public long getAllCommandId() {
        long defaultId = 0L;
        long allCommandId = 0L;
        SgipPacketType[] sgipPacketTypeArray = SgipPacketType.values();
        int n = sgipPacketTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SgipPacketType packetType = sgipPacketTypeArray[n2];
            allCommandId |= packetType.commandId;
            ++n2;
        }
        return allCommandId ^ defaultId;
    }

    @Override
    public MessageToMessageCodec getCodec() {
        try {
            return this.codec.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

