/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smgp.codec;

import com.zx.sms.codec.smgp.msg.SMGPActiveTestMessage;
import com.zx.sms.codec.smgp.msg.SMGPActiveTestRespMessage;
import com.zx.sms.codec.smgp.msg.SMGPBaseMessage;
import com.zx.sms.codec.smgp.msg.SMGPDeliverMessage;
import com.zx.sms.codec.smgp.msg.SMGPDeliverRespMessage;
import com.zx.sms.codec.smgp.msg.SMGPExitMessage;
import com.zx.sms.codec.smgp.msg.SMGPExitRespMessage;
import com.zx.sms.codec.smgp.msg.SMGPLoginMessage;
import com.zx.sms.codec.smgp.msg.SMGPLoginRespMessage;
import com.zx.sms.codec.smgp.msg.SMGPSubmitMessage;
import com.zx.sms.codec.smgp.msg.SMGPSubmitRespMessage;
import com.zx.sms.codec.smgp.msg.SMGPUnknownMessage;
import com.zx.sms.codec.smgp.util.ByteUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;

public class SMGPMessageCodec
extends MessageToMessageCodec<ByteBuf, SMGPBaseMessage> {
    protected void encode(ChannelHandlerContext ctx, SMGPBaseMessage msg, List<Object> out) throws Exception {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])msg.toBytes());
        out.add(buf);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        int length = buf.readableBytes();
        byte[] data = new byte[length];
        buf.readBytes(data);
        SMGPBaseMessage msg = this.fromBytes(data);
        out.add(msg);
    }

    private SMGPBaseMessage fromBytes(byte[] bytes) throws Exception {
        if (bytes == null) {
            return null;
        }
        if (bytes.length < 12) {
            return null;
        }
        int commandLength = ByteUtil.byte2int(bytes, 0);
        assert (bytes.length == commandLength);
        int commandId = ByteUtil.byte2int(bytes, 4);
        SMGPBaseMessage baseMsg = null;
        switch (commandId) {
            case 1: {
                baseMsg = new SMGPLoginMessage();
                break;
            }
            case -2147483647: {
                baseMsg = new SMGPLoginRespMessage();
                break;
            }
            case 2: {
                baseMsg = new SMGPSubmitMessage();
                break;
            }
            case -2147483646: {
                baseMsg = new SMGPSubmitRespMessage();
                break;
            }
            case 3: {
                baseMsg = new SMGPDeliverMessage();
                break;
            }
            case -2147483645: {
                baseMsg = new SMGPDeliverRespMessage();
                break;
            }
            case 4: {
                baseMsg = new SMGPActiveTestMessage();
                break;
            }
            case -2147483644: {
                baseMsg = new SMGPActiveTestRespMessage();
                break;
            }
            case 6: {
                baseMsg = new SMGPExitMessage();
                break;
            }
            case -2147483642: {
                baseMsg = new SMGPExitRespMessage();
                break;
            }
            default: {
                baseMsg = new SMGPUnknownMessage(commandId);
            }
        }
        baseMsg.fromBytes(bytes);
        return baseMsg;
    }
}

