/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smgp.msg;

import com.zx.sms.BaseMessage;
import com.zx.sms.codec.smgp.tlv.TLV;
import com.zx.sms.codec.smgp.util.ByteUtil;
import com.zx.sms.common.util.CachedMillisecondClock;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class SMGPBaseMessage
implements BaseMessage,
Cloneable {
    private static final long serialVersionUID = -5011411627951305409L;
    public static final int SZ_HEADER = 12;
    protected int commandLength = 0;
    protected int commandId = 0;
    protected long sequenceNumber = DefaultSequenceNumberUtil.getSequenceNo();
    protected List<TLV> optionalParameters = new ArrayList<TLV>();
    private BaseMessage request;
    private long timestamp = CachedMillisecondClock.INS.now();
    private long lifeTime = 0L;

    public boolean fromBytes(byte[] bytes) throws Exception {
        if (bytes == null) {
            return false;
        }
        if (bytes.length < 12) {
            return false;
        }
        int offset = 0;
        this.commandLength = ByteUtil.byte2int(bytes, offset);
        this.commandId = ByteUtil.byte2int(bytes, offset += 4);
        this.sequenceNumber = ByteUtil.byte2int(bytes, offset += 4);
        byte[] bodyBytes = new byte[this.commandLength - 12];
        System.arraycopy(bytes, offset += 4, bodyBytes, 0, bodyBytes.length);
        int bodyLength = this.setBody(bodyBytes);
        if (bodyLength < bodyBytes.length) {
            byte[] optBytes = new byte[bodyBytes.length - bodyLength];
            System.arraycopy(bodyBytes, bodyLength, optBytes, 0, optBytes.length);
            this.setOptionalBody(optBytes);
        }
        return true;
    }

    public byte[] toBytes() throws Exception {
        byte[] bodyBytes = this.getBody();
        byte[] optBytes = this.getOptionalBody();
        this.commandLength = 12 + bodyBytes.length + optBytes.length;
        int offset = 0;
        byte[] bytes = new byte[this.commandLength];
        ByteUtil.int2byte(this.commandLength, bytes, offset);
        ByteUtil.int2byte(this.commandId, bytes, offset += 4);
        ByteUtil.int2byte((int)this.sequenceNumber, bytes, offset += 4);
        System.arraycopy(bodyBytes, 0, bytes, offset += 4, bodyBytes.length);
        System.arraycopy(optBytes, 0, bytes, offset += bodyBytes.length, optBytes.length);
        offset += optBytes.length;
        return bytes;
    }

    protected abstract int setBody(byte[] var1) throws Exception;

    protected abstract byte[] getBody() throws Exception;

    private void setOptionalBody(byte[] buffer) throws Exception {
        int offset = 0;
        TLV tlv = null;
        while (offset < buffer.length) {
            short tag = ByteUtil.byte2short(buffer, offset);
            offset += 2;
            tlv = this.findOptional(tag);
            if (tlv == null) break;
            short length = ByteUtil.byte2short(buffer, offset);
            byte[] valueBytes = new byte[length];
            System.arraycopy(buffer, offset += 2, valueBytes, 0, length);
            offset += length;
            tlv.setValueData(valueBytes);
        }
    }

    private byte[] getOptionalBody() throws Exception {
        int size = this.optionalParameters.size();
        TLV tlv = null;
        int len = 0;
        int i = 0;
        while (i < size) {
            tlv = this.optionalParameters.get(i);
            if (tlv.hasValue()) {
                len += 4 + tlv.getLength();
            }
            ++i;
        }
        byte[] bytes = new byte[len];
        int offset = 0;
        int i2 = 0;
        while (i2 < size) {
            tlv = this.optionalParameters.get(i2);
            offset = tlv.toBytes(bytes, offset);
            ++i2;
        }
        if (offset == 0) {
            return new byte[0];
        }
        byte[] result = new byte[offset];
        System.arraycopy(bytes, 0, result, 0, offset);
        return result;
    }

    protected void registerOptional(TLV tlv) {
        if (tlv != null) {
            this.optionalParameters.add(tlv);
        }
    }

    private TLV findOptional(short tag) {
        int size = this.optionalParameters.size();
        TLV tlv = null;
        int i = 0;
        while (i < size) {
            tlv = this.optionalParameters.get(i);
            if (tlv != null && tlv.getTag() == tag) {
                return tlv;
            }
            ++i;
        }
        return null;
    }

    protected String plus86(String mobile) {
        if (mobile == null || mobile.trim().length() == 0) {
            return "";
        }
        if (mobile.startsWith("86")) {
            return mobile;
        }
        if (mobile.startsWith("+86")) {
            return mobile.substring(1);
        }
        return "86" + mobile;
    }

    protected String minus86(String mobile) {
        if (mobile == null || mobile.trim().length() == 0) {
            return "";
        }
        if (mobile.startsWith("86")) {
            return mobile.substring(2);
        }
        if (mobile.startsWith("+86")) {
            return mobile.substring(3);
        }
        return mobile;
    }

    public int getCommandId() {
        return this.commandId;
    }

    public void setCommandId(int commandId) {
        this.commandId = commandId;
    }

    public int getCommandLength() {
        return this.commandLength;
    }

    public void setCommandLength(int commandLength) {
        this.commandLength = commandLength;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String sequenceString() {
        StringBuffer buffer = new StringBuffer();
        int offset = 0;
        byte[] seqBytes = new byte[8];
        System.arraycopy(ByteUtil.int2byte((int)this.sequenceNumber), offset, seqBytes, 4, 4);
        buffer.append(ByteUtil.byte2long(seqBytes));
        return buffer.toString();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public void setLifeTime(long lifeTime) {
        this.lifeTime = lifeTime;
    }

    @Override
    public boolean isRequest() {
        return ((long)this.commandId & 0x80000000L) == 0L;
    }

    @Override
    public boolean isResponse() {
        return ((long)this.commandId & 0x80000000L) == 0x80000000L;
    }

    @Override
    public boolean isTerminated() {
        return this.lifeTime != 0L && this.timestamp + this.lifeTime * 1000L - CachedMillisecondClock.INS.now() < 0L;
    }

    @Override
    public void setRequest(BaseMessage message) {
        this.request = message;
    }

    @Override
    public BaseMessage getRequest() {
        return this.request;
    }

    @Override
    public long getSequenceNo() {
        return this.sequenceNumber;
    }

    @Override
    public void setSequenceNo(long seq) {
        this.sequenceNumber = seq;
    }

    protected SMGPBaseMessage clone() throws CloneNotSupportedException {
        SMGPBaseMessage msg = (SMGPBaseMessage)super.clone();
        msg.setSequenceNumber(this.sequenceNumber);
        msg.setCommandId(this.commandId);
        return msg;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SMGPBaseMessage:[sequenceNumber=").append(this.sequenceString()).append(",").append("commandId=").append(this.commandId).append("]");
        return buffer.toString();
    }
}

