/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smgp.msg;

import com.zx.sms.codec.smgp.msg.MsgId;
import com.zx.sms.codec.smgp.msg.SMGPBaseMessage;
import com.zx.sms.codec.smgp.util.ByteUtil;
import com.zx.sms.codec.smgp.util.SMGPMsgIdUtil;

public class SMGPDeliverRespMessage
extends SMGPBaseMessage {
    private static final long serialVersionUID = 928417176516979508L;
    private MsgId msgId = new MsgId();
    private int status;

    public SMGPDeliverRespMessage() {
        this.commandId = -2147483645;
    }

    @Override
    protected int setBody(byte[] bodyBytes) throws Exception {
        int offset = 0;
        byte[] msgId = new byte[10];
        System.arraycopy(bodyBytes, offset, msgId, 0, 10);
        this.msgId = SMGPMsgIdUtil.bytes2MsgId(msgId);
        this.status = ByteUtil.byte2int(bodyBytes, offset += 10);
        return offset += 4;
    }

    @Override
    protected byte[] getBody() throws Exception {
        int len = 14;
        int offset = 0;
        byte[] bodyBytes = new byte[len];
        byte[] b_msgId = SMGPMsgIdUtil.msgId2Bytes(this.msgId);
        System.arraycopy(b_msgId, 0, bodyBytes, offset, 10);
        ByteUtil.int2byte(this.status, bodyBytes, offset += 10);
        offset += 4;
        return bodyBytes;
    }

    public MsgId getMsgId() {
        return this.msgId;
    }

    public void setMsgId(MsgId msgId) {
        this.msgId = msgId;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    private String msgIdString() {
        return this.msgId.toString();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SMGPDeliverRespMessage:[sequenceNumber=").append(this.sequenceString()).append(",");
        buffer.append("msgId=").append(this.msgIdString()).append(",");
        buffer.append("status=").append(this.status);
        buffer.append("]");
        return buffer.toString();
    }
}

