/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smgp.msg;

import com.zx.sms.codec.smgp.msg.SMGPBaseMessage;
import com.zx.sms.codec.smgp.util.ByteUtil;
import org.apache.commons.codec.binary.Hex;

public class SMGPLoginRespMessage
extends SMGPBaseMessage {
    private static final long serialVersionUID = 7921237368321175055L;
    private int status;
    private byte[] serverAuth = new byte[16];
    private byte version;

    public SMGPLoginRespMessage() {
        this.commandId = -2147483647;
    }

    @Override
    protected int setBody(byte[] bodyBytes) throws Exception {
        int offset = 0;
        this.status = ByteUtil.byte2int(bodyBytes, offset);
        this.serverAuth = new byte[16];
        System.arraycopy(bodyBytes, offset += 4, this.serverAuth, 0, 16);
        this.version = bodyBytes[offset += 16];
        return ++offset;
    }

    @Override
    protected byte[] getBody() throws Exception {
        int len = 21;
        int offset = 0;
        byte[] bodyBytes = new byte[len];
        ByteUtil.int2byte(this.status, bodyBytes, offset);
        System.arraycopy(this.serverAuth, 0, bodyBytes, offset += 4, 16);
        bodyBytes[offset += 16] = this.version;
        ++offset;
        return bodyBytes;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public byte[] getServerAuth() {
        return this.serverAuth;
    }

    public void setServerAuth(byte[] serverAuth) {
        this.serverAuth = serverAuth;
    }

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SMGPLoginRespMessage:[sequenceNumber=").append(this.sequenceString()).append(",");
        buffer.append("status=").append(this.status).append(",");
        buffer.append("serverAuth=").append(Hex.encodeHex((byte[])this.serverAuth)).append(",");
        buffer.append("version=").append(this.version).append("]");
        return buffer.toString();
    }
}

