/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smgp.msg;

import com.zx.sms.codec.smgp.msg.MsgId;
import com.zx.sms.codec.smgp.util.ByteUtil;
import com.zx.sms.codec.smgp.util.SMGPMsgIdUtil;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMGPReportData {
    private static final Logger logger = LoggerFactory.getLogger(SMGPReportData.class);
    public static final int LENGTH = 66 + "id: sub: dlvrd: submit date: done date: stat: err: text:".length();
    private MsgId msgId;
    private String sub = "001";
    private String dlvrd = "001";
    private String subTime;
    private String doneTime;
    private String stat;
    private String err = "";
    private String txt = "";

    public boolean fromBytes(byte[] bytes) throws Exception {
        try {
            int offset = 0;
            byte[] tmp = null;
            byte[] msgId = new byte[10];
            System.arraycopy(bytes, offset += "id:".length(), msgId, 0, 10);
            this.msgId = SMGPMsgIdUtil.bytes2MsgId(msgId);
            offset += 10;
            tmp = new byte[3];
            System.arraycopy(bytes, offset += " sub:".length(), tmp, 0, 3);
            this.sub = new String(ByteUtil.rtrimBytes(tmp));
            offset += 3;
            tmp = new byte[3];
            System.arraycopy(bytes, offset += " dlvrd:".length(), tmp, 0, 3);
            this.dlvrd = new String(ByteUtil.rtrimBytes(tmp));
            offset += 3;
            tmp = new byte[10];
            System.arraycopy(bytes, offset += " submit date:".length(), tmp, 0, 10);
            this.subTime = new String(ByteUtil.rtrimBytes(tmp));
            offset += 10;
            tmp = new byte[10];
            System.arraycopy(bytes, offset += " done date:".length(), tmp, 0, 10);
            this.doneTime = new String(ByteUtil.rtrimBytes(tmp));
            offset += 10;
            tmp = new byte[7];
            System.arraycopy(bytes, offset += " stat:".length(), tmp, 0, 7);
            this.stat = new String(ByteUtil.rtrimBytes(tmp));
            offset += 7;
            tmp = new byte[3];
            System.arraycopy(bytes, offset += " err:".length(), tmp, 0, 3);
            this.err = new String(ByteUtil.rtrimBytes(tmp));
            offset += 3;
            tmp = new byte[20];
            System.arraycopy(bytes, offset += " text:".length(), tmp, 0, bytes.length - offset);
            this.txt = new String(ByteUtil.rtrimBytes(tmp));
            offset += 20;
            return true;
        }
        catch (Exception ex) {
            logger.warn("parse data err length:{} ; 0x{}", (Object)bytes.length, (Object)Hex.encodeHexString((byte[])bytes));
            return true;
        }
    }

    public byte[] toBytes() throws Exception {
        int offset = 0;
        byte[] bytes = new byte[LENGTH];
        System.arraycopy("id:".getBytes(), 0, bytes, offset, "id:".length());
        byte[] b_msgId = SMGPMsgIdUtil.msgId2Bytes(this.msgId);
        System.arraycopy(b_msgId, 0, bytes, offset += "id:".length(), 10);
        System.arraycopy(" sub:".getBytes(), 0, bytes, offset += 10, " sub:".length());
        ByteUtil.rfillBytes(this.sub.getBytes(), 3, bytes, offset += " sub:".length());
        System.arraycopy(" dlvrd:".getBytes(), 0, bytes, offset += 3, " dlvrd:".length());
        ByteUtil.rfillBytes(this.dlvrd.getBytes(), 3, bytes, offset += " dlvrd:".length());
        System.arraycopy(" submit date:".getBytes(), 0, bytes, offset += 3, " submit date:".length());
        ByteUtil.rfillBytes(this.subTime.getBytes(), 10, bytes, offset += " submit date:".length());
        System.arraycopy(" done date:".getBytes(), 0, bytes, offset += 10, " done date:".length());
        ByteUtil.rfillBytes(this.doneTime.getBytes(), 10, bytes, offset += " done date:".length());
        System.arraycopy(" stat:".getBytes(), 0, bytes, offset += 10, " stat:".length());
        ByteUtil.rfillBytes(this.stat.getBytes(), 7, bytes, offset += " stat:".length());
        System.arraycopy(" err:".getBytes(), 0, bytes, offset += 7, " err:".length());
        ByteUtil.rfillBytes(this.err.getBytes(), 3, bytes, offset += " err:".length());
        System.arraycopy(" text:".getBytes(), 0, bytes, offset += 3, " text:".length());
        ByteUtil.rfillBytes(this.txt.getBytes(), 20, bytes, offset += " text:".length());
        offset += 20;
        return bytes;
    }

    public String getDlvrd() {
        return this.dlvrd;
    }

    public void setDlvrd(String dlvrd) {
        this.dlvrd = dlvrd;
    }

    public String getDoneTime() {
        return this.doneTime;
    }

    public void setDoneTime(String doneTime) {
        this.doneTime = doneTime;
    }

    public String getErr() {
        return this.err;
    }

    public void setErr(String err) {
        this.err = err;
    }

    public MsgId getMsgId() {
        return this.msgId;
    }

    public void setMsgId(MsgId msgId) {
        this.msgId = msgId;
    }

    public String getStat() {
        return this.stat;
    }

    public void setStat(String stat) {
        this.stat = stat;
    }

    public String getSub() {
        return this.sub;
    }

    public void setSub(String sub) {
        this.sub = sub;
    }

    public String getSubTime() {
        return this.subTime;
    }

    public void setSubTime(String subTime) {
        this.subTime = subTime;
    }

    public String getTxt() {
        return this.txt;
    }

    public void setTxt(String txt) {
        this.txt = txt;
    }

    private String msgIdString() {
        return this.msgId.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{msgId=").append(this.msgIdString()).append(",").append("sub=").append(this.sub).append(",").append("dlvrd=").append(this.dlvrd).append(",").append("subTime=").append(this.subTime).append(",").append("doneTime=").append(this.doneTime).append(",").append("stat=").append(this.stat).append(",").append("err=").append(this.err).append(",").append("text=").append(this.txt).append("}");
        return buffer.toString();
    }
}

