/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smgp.msg;

import com.zx.sms.LongSMSMessage;
import com.zx.sms.codec.cmpp.wap.LongMessageFrame;
import com.zx.sms.codec.cmpp.wap.LongMessageFrameHolder;
import com.zx.sms.codec.smgp.msg.SMGPBaseMessage;
import com.zx.sms.codec.smgp.tlv.TLVByte;
import com.zx.sms.codec.smgp.tlv.TLVString;
import com.zx.sms.codec.smgp.util.ByteUtil;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.util.CMPPCommonUtil;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import java.util.ArrayList;
import java.util.List;
import org.marre.sms.SmsDcs;
import org.marre.sms.SmsMessage;

public class SMGPSubmitMessage
extends SMGPBaseMessage
implements LongSMSMessage<SMGPSubmitMessage> {
    private static final long serialVersionUID = 1347896099727385979L;
    private byte msgType = (byte)6;
    private boolean needReport = true;
    private byte priority = (byte)2;
    private String serviceId = "";
    private String feeType = "00";
    private String feeCode = "000000";
    private String fixedFee = "000000";
    private SmsDcs msgFmt = GlobalConstance.defaultmsgfmt;
    private String validTime = "";
    private String atTime = "";
    private String srcTermId = "";
    private String chargeTermId = "";
    private byte destTermIdCount;
    private String[] destTermIdArray;
    private byte[] bMsgContent;
    private String reserve = "";
    private SmsMessage msg;
    private TLVByte tpPid = new TLVByte(1);
    private TLVByte tpUdhi = new TLVByte(2);
    private TLVString linkId = new TLVString(3);
    private TLVString msgSrc = new TLVString(16);
    private TLVByte chargeUserType = new TLVByte(4);
    private TLVByte chargeTermType = new TLVByte(5);
    private TLVString chargeTermPseudo = new TLVString(6);
    private TLVByte destTermType = new TLVByte(7);
    private TLVString destTermPseudo = new TLVString(8);
    private TLVByte pkTotal = new TLVByte(9);
    private TLVByte pkNumber = new TLVByte(10);
    private TLVByte submitMsgType = new TLVByte(11);
    private TLVByte spDealResult = new TLVByte(12);
    private TLVString mServiceId = new TLVString(18);
    private List<SMGPSubmitMessage> fragments = null;

    public SMGPSubmitMessage() {
        this.commandId = 2;
        this.registerOptional(this.tpPid);
        this.registerOptional(this.tpUdhi);
        this.registerOptional(this.linkId);
        this.registerOptional(this.msgSrc);
        this.registerOptional(this.chargeUserType);
        this.registerOptional(this.chargeTermType);
        this.registerOptional(this.chargeTermPseudo);
        this.registerOptional(this.destTermType);
        this.registerOptional(this.destTermPseudo);
        this.registerOptional(this.pkTotal);
        this.registerOptional(this.pkNumber);
        this.registerOptional(this.submitMsgType);
        this.registerOptional(this.spDealResult);
        this.registerOptional(this.mServiceId);
    }

    public void setTpPid(byte value) {
        this.tpPid.setValue(value);
    }

    public byte getTpPid() {
        return this.tpPid.getValue();
    }

    public void setTpUdhi(byte value) {
        this.tpUdhi.setValue(value);
    }

    public byte getTpUdhi() {
        return this.tpUdhi.getValue();
    }

    public void setLinkId(String value) {
        this.linkId.setValue(value);
    }

    public String getLinkId() {
        return this.linkId.getValue();
    }

    public void setMsgSrc(String value) {
        this.msgSrc.setValue(value);
    }

    public String getMsgSrc() {
        return this.msgSrc.getValue();
    }

    public void setChargeUserType(byte value) {
        this.chargeUserType.setValue(value);
    }

    public byte getChargeUserType() {
        return this.chargeUserType.getValue();
    }

    public void setChargeTermType(byte value) {
        this.chargeTermType.setValue(value);
    }

    public byte getChargeTermType() {
        return this.chargeTermType.getValue();
    }

    public void setChargeTermPseudo(String value) {
        this.chargeTermPseudo.setValue(value);
    }

    public String getChargeTermPseudo() {
        return this.chargeTermPseudo.getValue();
    }

    @Override
    public boolean isReport() {
        return false;
    }

    public void setDestTermType(byte value) {
        this.destTermType.setValue(value);
    }

    public byte getDestTermType() {
        return this.destTermType.getValue();
    }

    public void setDestTermPseudo(String value) {
        this.destTermPseudo.setValue(value);
    }

    public String getDestTermPseudo() {
        return this.destTermPseudo.getValue();
    }

    public void setPkTotal(byte value) {
        this.pkTotal.setValue(value);
    }

    public byte getPkTotal() {
        return this.pkTotal.getValue();
    }

    public void setPkNumber(byte value) {
        this.pkNumber.setValue(value);
    }

    public byte getPkNumber() {
        return this.pkNumber.getValue();
    }

    public void setSubmitMsgType(byte value) {
        this.submitMsgType.setValue(value);
    }

    public byte getSubmitMsgType() {
        return this.submitMsgType.getValue();
    }

    public void setSpDealResult(byte value) {
        this.spDealResult.setValue(value);
    }

    public byte getSpDealResult() {
        return this.spDealResult.getValue();
    }

    public void setMServiceId(String value) {
        this.mServiceId.setValue(value);
    }

    public String getMServiceId() {
        return this.mServiceId.getValue();
    }

    @Override
    protected int setBody(byte[] bodyBytes) throws Exception {
        int msgLength;
        int offset = 0;
        byte[] tmp = null;
        this.msgType = bodyBytes[offset];
        this.needReport = bodyBytes[++offset] == 1;
        this.priority = bodyBytes[++offset];
        tmp = new byte[10];
        System.arraycopy(bodyBytes, ++offset, tmp, 0, 10);
        this.serviceId = new String(ByteUtil.rtrimBytes(tmp));
        tmp = new byte[2];
        System.arraycopy(bodyBytes, offset += 10, tmp, 0, 2);
        this.feeType = new String(ByteUtil.rtrimBytes(tmp));
        tmp = new byte[6];
        System.arraycopy(bodyBytes, offset += 2, tmp, 0, 6);
        this.feeCode = new String(ByteUtil.rtrimBytes(tmp));
        tmp = new byte[6];
        System.arraycopy(bodyBytes, offset += 6, tmp, 0, 6);
        this.fixedFee = new String(ByteUtil.rtrimBytes(tmp));
        this.msgFmt = new SmsDcs(bodyBytes[offset += 6]);
        tmp = new byte[17];
        System.arraycopy(bodyBytes, ++offset, tmp, 0, 17);
        this.validTime = new String(ByteUtil.rtrimBytes(tmp));
        tmp = new byte[17];
        System.arraycopy(bodyBytes, offset += 17, tmp, 0, 17);
        this.atTime = new String(ByteUtil.rtrimBytes(tmp));
        tmp = new byte[21];
        System.arraycopy(bodyBytes, offset += 17, tmp, 0, 21);
        this.srcTermId = new String(ByteUtil.rtrimBytes(tmp));
        tmp = new byte[21];
        System.arraycopy(bodyBytes, offset += 21, tmp, 0, 21);
        this.chargeTermId = new String(ByteUtil.rtrimBytes(tmp));
        this.destTermIdCount = bodyBytes[offset += 21];
        ++offset;
        if (this.destTermIdCount >= 100 || this.destTermIdCount <= 0) {
            throw new Exception("destTermIdCount must be in [1,99],but " + this.destTermIdCount);
        }
        this.destTermIdArray = new String[this.destTermIdCount];
        int i = 0;
        while (i < this.destTermIdCount) {
            tmp = new byte[21];
            System.arraycopy(bodyBytes, offset, tmp, 0, 21);
            offset += 21;
            this.destTermIdArray[i] = new String(ByteUtil.rtrimBytes(tmp));
            ++i;
        }
        int b = bodyBytes[offset];
        ++offset;
        int n = msgLength = b >= 0 ? b : 256 + b;
        if (msgLength > 0) {
            tmp = new byte[msgLength];
            System.arraycopy(bodyBytes, offset, tmp, 0, msgLength);
            offset += msgLength;
            this.bMsgContent = tmp;
        }
        tmp = new byte[8];
        System.arraycopy(bodyBytes, offset, tmp, 0, 8);
        this.reserve = new String(ByteUtil.rtrimBytes(tmp));
        return offset += 8;
    }

    @Override
    protected byte[] getBody() throws Exception {
        int msgLength = this.bMsgContent.length;
        int len = 105 + 21 * this.destTermIdCount + 1 + msgLength + 8;
        int offset = 0;
        byte[] bodyBytes = new byte[len];
        bodyBytes[offset] = this.msgType;
        bodyBytes[++offset] = this.needReport ? (byte)1 : 0;
        bodyBytes[++offset] = this.priority;
        ByteUtil.rfillBytes(this.serviceId.getBytes(), 10, bodyBytes, ++offset);
        ByteUtil.rfillBytes(this.feeType.getBytes(), 2, bodyBytes, offset += 10);
        ByteUtil.rfillBytes(this.feeCode.getBytes(), 6, bodyBytes, offset += 2);
        ByteUtil.rfillBytes(this.fixedFee.getBytes(), 6, bodyBytes, offset += 6);
        bodyBytes[offset += 6] = this.msgFmt.getValue();
        ByteUtil.rfillBytes(this.validTime.getBytes(), 17, bodyBytes, ++offset);
        ByteUtil.rfillBytes(this.atTime.getBytes(), 17, bodyBytes, offset += 17);
        ByteUtil.rfillBytes(this.srcTermId.getBytes(), 21, bodyBytes, offset += 17);
        ByteUtil.rfillBytes(this.chargeTermId.getBytes(), 21, bodyBytes, offset += 21);
        bodyBytes[offset += 21] = this.destTermIdCount;
        ++offset;
        int i = 0;
        while (i < this.destTermIdCount) {
            ByteUtil.rfillBytes(this.destTermIdArray[i].getBytes(), 21, bodyBytes, offset);
            offset += 21;
            ++i;
        }
        bodyBytes[offset] = (byte)msgLength;
        ++offset;
        if (this.bMsgContent != null) {
            ByteUtil.rfillBytes(this.bMsgContent, msgLength, bodyBytes, offset);
        }
        ByteUtil.rfillBytes(this.reserve.getBytes(), 8, bodyBytes, offset += msgLength);
        offset += 8;
        return bodyBytes;
    }

    public byte getMsgType() {
        return this.msgType;
    }

    public void setMsgType(byte msgType) {
        this.msgType = msgType;
    }

    public boolean isNeedReport() {
        return this.needReport;
    }

    public void setNeedReport(boolean needReport) {
        this.needReport = needReport;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getFeeType() {
        return this.feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public String getFeeCode() {
        return this.feeCode;
    }

    public void setFeeCode(String feeCode) {
        this.feeCode = feeCode;
    }

    public String getFixedFee() {
        return this.fixedFee;
    }

    public void setFixedFee(String fixedFee) {
        this.fixedFee = fixedFee;
    }

    public SmsDcs getMsgFmt() {
        return this.msgFmt;
    }

    public void setMsgFmt(SmsDcs msgFmt) {
        this.msgFmt = msgFmt;
    }

    public String getValidTime() {
        return this.validTime;
    }

    public void setValidTime(String validTime) {
        this.validTime = validTime;
    }

    public String getAtTime() {
        return this.atTime;
    }

    public void setAtTime(String atTime) {
        this.atTime = atTime;
    }

    public String getSrcTermId() {
        return this.srcTermId;
    }

    public void setSrcTermId(String srcTermId) {
        this.srcTermId = srcTermId;
    }

    public String getChargeTermId() {
        return this.chargeTermId;
    }

    public void setChargeTermId(String chargeTermId) {
        this.chargeTermId = chargeTermId;
    }

    public byte getDestTermIdCount() {
        return this.destTermIdCount;
    }

    public String[] getDestTermIdArray() {
        return this.destTermIdArray;
    }

    public void setDestTermIdArray(String destTermIdArray) {
        this.destTermIdArray = new String[]{destTermIdArray};
        this.destTermIdCount = 1;
    }

    public void setDestTermIdArray(String[] destTermIdArray) {
        this.destTermIdArray = destTermIdArray;
        this.destTermIdCount = (byte)(destTermIdArray == null ? 0 : destTermIdArray.length);
    }

    public void setMsgContent(String msgContent) {
        this.setMsgContent(CMPPCommonUtil.buildTextMessage(msgContent));
    }

    public void setMsgContent(SmsMessage msg) {
        this.msg = msg;
    }

    @Override
    public SmsMessage getSmsMessage() {
        return this.msg;
    }

    public byte[] getBMsgContent() {
        return this.bMsgContent;
    }

    public void setBMsgContent(byte[] msgContent) {
        this.bMsgContent = msgContent;
    }

    public String getReserve() {
        return this.reserve;
    }

    public void setReserve(String reserve) {
        this.reserve = reserve;
    }

    public String getMsgContent() {
        if (this.msg instanceof SmsMessage) {
            return this.msg.toString();
        }
        if (this.bMsgContent != null && this.bMsgContent.length > 0) {
            LongMessageFrame frame = this.generateFrame();
            return LongMessageFrameHolder.INS.getPartTextMsg(frame);
        }
        return "";
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SMGPSubmitMessage:[sequenceNumber=").append(this.sequenceString()).append(",");
        buffer.append("msgType=").append(this.msgType).append(",");
        buffer.append("needReport=").append(this.needReport).append(",");
        buffer.append("validTime=").append(this.validTime).append(",");
        buffer.append("atTime=").append(this.atTime).append(",");
        buffer.append("srcTermId=").append(this.srcTermId).append(",");
        buffer.append("chargeTermId=").append(this.chargeTermId).append(",");
        buffer.append("destTermIdArray={");
        int i = 0;
        while (i < this.destTermIdCount) {
            if (i == 0) {
                buffer.append(this.destTermIdArray[i]);
            } else {
                buffer.append(";" + this.destTermIdArray[i]);
            }
            ++i;
        }
        buffer.append("},");
        buffer.append("msgContent=").append(this.getMsgContent()).append("]");
        return buffer.toString();
    }

    @Override
    public SMGPSubmitMessage clone() throws CloneNotSupportedException {
        SMGPSubmitMessage cloned = new SMGPSubmitMessage();
        cloned.setAtTime(this.getAtTime());
        cloned.setChargeTermId(this.getChargeTermId());
        cloned.setChargeTermPseudo(this.getChargeTermPseudo());
        cloned.setChargeTermType(this.getChargeTermType());
        cloned.setChargeUserType(this.getChargeUserType());
        cloned.setDestTermIdArray(this.getDestTermIdArray());
        cloned.setDestTermPseudo(this.getDestTermPseudo());
        cloned.setDestTermType(this.getDestTermType());
        cloned.setSpDealResult(this.getSpDealResult());
        cloned.setFeeCode(this.getFeeCode());
        cloned.setFeeType(this.getFeeType());
        cloned.setFixedFee(this.getFixedFee());
        cloned.setLifeTime(this.getLifeTime());
        cloned.setLinkId(this.getLinkId());
        cloned.setMServiceId(this.getMServiceId());
        cloned.setMsgType(this.getMsgType());
        cloned.setMsgSrc(this.getMsgSrc());
        cloned.setNeedReport(this.isNeedReport());
        cloned.setPkNumber(this.getPkNumber());
        cloned.setPriority(this.getPriority());
        cloned.setReserve(this.getReserve());
        cloned.setSpDealResult(this.getSpDealResult());
        cloned.setSrcTermId(this.getSrcTermId());
        cloned.setSubmitMsgType(this.getSubmitMsgType());
        cloned.setTpPid(this.getTpPid());
        cloned.setTpUdhi(this.getTpUdhi());
        cloned.setPkNumber(this.getPkNumber());
        cloned.setPkTotal(this.getPkTotal());
        cloned.setValidTime(this.getValidTime());
        cloned.setMsgFmt(this.getMsgFmt());
        cloned.setBMsgContent(this.getBMsgContent());
        cloned.setMsgContent(this.getSmsMessage());
        return cloned;
    }

    @Override
    public LongMessageFrame generateFrame() {
        LongMessageFrame frame = new LongMessageFrame();
        frame.setTppid(this.getTpPid());
        frame.setTpudhi(this.getTpUdhi());
        frame.setMsgfmt(this.getMsgFmt());
        frame.setMsgContentBytes(this.getBMsgContent());
        frame.setMsgLength((short)this.bMsgContent.length);
        frame.setSequence(this.getSequenceNo());
        return frame;
    }

    @Override
    public SMGPSubmitMessage generateMessage(LongMessageFrame frame) throws Exception {
        SMGPSubmitMessage requestMessage = this.clone();
        requestMessage.setTpUdhi((byte)frame.getTpudhi());
        requestMessage.setMsgFmt(frame.getMsgfmt());
        requestMessage.setBMsgContent(frame.getMsgContentBytes());
        requestMessage.setPkTotal((byte)frame.getPktotal());
        requestMessage.setPkNumber((byte)frame.getPknumber());
        if (frame.getPknumber() != 1) {
            requestMessage.setSequenceNumber(DefaultSequenceNumberUtil.getSequenceNo());
        }
        requestMessage.setMsgContent((SmsMessage)null);
        return requestMessage;
    }

    @Override
    public List<SMGPSubmitMessage> getFragments() {
        return this.fragments;
    }

    @Override
    public void addFragment(SMGPSubmitMessage fragment) {
        if (this.fragments == null) {
            this.fragments = new ArrayList<SMGPSubmitMessage>();
        }
        this.fragments.add(fragment);
    }
}

