/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smpp;

import com.zx.sms.codec.smpp.UnrecoverablePduException;
import com.zx.sms.codec.smpp.msg.BaseBindResp;
import com.zx.sms.common.util.HexUtil;

public class SmppBindException
extends UnrecoverablePduException {
    static final long serialVersionUID = 1L;
    private final BaseBindResp bindResponse;

    public SmppBindException(BaseBindResp bindResponse) {
        super(SmppBindException.buildErrorMessage(bindResponse));
        this.bindResponse = bindResponse;
    }

    public BaseBindResp getBindResponse() {
        return this.bindResponse;
    }

    public static String buildErrorMessage(BaseBindResp bindResponse) {
        if (bindResponse == null) {
            return "Bind request failed (response was null)";
        }
        return "Unable to bind [error: 0x" + HexUtil.toHexString(bindResponse.getCommandStatus()) + " \"" + bindResponse.getResultMessage() + "\"]";
    }
}

