/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smpp.msg;

import com.zx.sms.BaseMessage;
import com.zx.sms.codec.smpp.Address;
import com.zx.sms.codec.smpp.RecoverablePduException;
import com.zx.sms.codec.smpp.UnrecoverablePduException;
import com.zx.sms.codec.smpp.msg.Pdu;
import com.zx.sms.common.util.ByteBufUtil;
import com.zx.sms.common.util.PduUtil;
import io.netty.buffer.ByteBuf;

public class AlertNotification
extends Pdu {
    private static final long serialVersionUID = 3381959655631251521L;
    protected Address sourceAddress;
    protected Address esmeAddress;

    public AlertNotification() {
        super(258, "alert_notification", true);
    }

    public Address getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(Address value) {
        this.sourceAddress = value;
    }

    public Address getEsmeAddress() {
        return this.esmeAddress;
    }

    public void setEsmeAddress(Address value) {
        this.esmeAddress = value;
    }

    @Override
    protected int calculateByteSizeOfBody() {
        int bodyLength = 0;
        bodyLength += PduUtil.calculateByteSizeOfAddress(this.sourceAddress);
        return bodyLength += PduUtil.calculateByteSizeOfAddress(this.esmeAddress);
    }

    @Override
    public void readBody(ByteBuf buffer) throws UnrecoverablePduException, RecoverablePduException {
        this.sourceAddress = ByteBufUtil.readAddress(buffer);
        this.esmeAddress = ByteBufUtil.readAddress(buffer);
    }

    @Override
    public void writeBody(ByteBuf buffer) throws UnrecoverablePduException, RecoverablePduException {
        ByteBufUtil.writeAddress(buffer, this.sourceAddress);
        ByteBufUtil.writeAddress(buffer, this.esmeAddress);
    }

    @Override
    protected void appendBodyToString(StringBuilder buffer) {
        buffer.append("( sourceAddr [");
        buffer.append(this.sourceAddress);
        buffer.append("] esmeAddr [");
        buffer.append(this.esmeAddress);
        buffer.append("])");
    }

    @Override
    public void setRequest(BaseMessage message) {
    }

    @Override
    public BaseMessage getRequest() {
        return null;
    }
}

