/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smpp.msg;

import com.zx.sms.LongSMSMessage;
import com.zx.sms.codec.cmpp.wap.LongMessageFrame;
import com.zx.sms.codec.smpp.RecoverablePduException;
import com.zx.sms.codec.smpp.UnrecoverablePduException;
import com.zx.sms.codec.smpp.msg.BaseSm;
import com.zx.sms.codec.smpp.msg.DataSmResp;
import com.zx.sms.common.util.ByteBufUtil;
import com.zx.sms.common.util.PduUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class DataSm
extends BaseSm<DataSmResp>
implements LongSMSMessage<DataSm> {
    private static final long serialVersionUID = -3066462470955865784L;
    private List<DataSm> fragments = null;

    public DataSm() {
        super(259, "data_sm");
    }

    @Override
    public DataSmResp createResponse() {
        DataSmResp resp = new DataSmResp();
        resp.setSequenceNumber(this.getSequenceNumber());
        return resp;
    }

    @Override
    public Class<DataSmResp> getResponseClass() {
        return DataSmResp.class;
    }

    @Override
    public void readBody(ByteBuf buffer) throws UnrecoverablePduException, RecoverablePduException {
        this.serviceType = ByteBufUtil.readNullTerminatedString(buffer);
        this.sourceAddress = ByteBufUtil.readAddress(buffer);
        this.destAddress = ByteBufUtil.readAddress(buffer);
        this.esmClass = buffer.readByte();
        this.registeredDelivery = buffer.readByte();
        this.dataCoding = buffer.readByte();
    }

    @Override
    public int calculateByteSizeOfBody() {
        int bodyLength = 0;
        bodyLength += PduUtil.calculateByteSizeOfNullTerminatedString(this.serviceType);
        bodyLength += PduUtil.calculateByteSizeOfAddress(this.sourceAddress);
        bodyLength += PduUtil.calculateByteSizeOfAddress(this.destAddress);
        return bodyLength += 3;
    }

    @Override
    public void writeBody(ByteBuf buffer) throws UnrecoverablePduException, RecoverablePduException {
        ByteBufUtil.writeNullTerminatedString(buffer, this.serviceType);
        ByteBufUtil.writeAddress(buffer, this.sourceAddress);
        ByteBufUtil.writeAddress(buffer, this.destAddress);
        buffer.writeByte((int)this.esmClass);
        buffer.writeByte((int)this.registeredDelivery);
        buffer.writeByte((int)this.dataCoding);
    }

    @Override
    public LongMessageFrame generateFrame() {
        return this.doGenerateFrame();
    }

    @Override
    public DataSm generateMessage(LongMessageFrame frame) {
        try {
            return (DataSm)this.doGenerateMessage(frame);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<DataSm> getFragments() {
        return this.fragments;
    }

    @Override
    public void addFragment(DataSm fragment) {
        if (this.fragments == null) {
            this.fragments = new ArrayList<DataSm>();
        }
        this.fragments.add(fragment);
    }
}

