/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.codec.smpp.msg;

import com.zx.sms.BaseMessage;
import com.zx.sms.codec.smpp.PduTranscoderContext;
import com.zx.sms.codec.smpp.RecoverablePduException;
import com.zx.sms.codec.smpp.Tlv;
import com.zx.sms.codec.smpp.UnrecoverablePduException;
import com.zx.sms.codec.smpp.msg.PduResponse;
import com.zx.sms.common.util.ByteBufUtil;
import com.zx.sms.common.util.CachedMillisecondClock;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import com.zx.sms.common.util.HexUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;

public abstract class Pdu
implements BaseMessage,
Cloneable {
    private final String name;
    private final boolean isRequest;
    private Integer commandLength;
    private final int commandId;
    private int commandStatus;
    private Integer sequenceNumber;
    private ArrayList<Tlv> optionalParameters;
    private Object referenceObject;
    private long timestamp = CachedMillisecondClock.INS.now();
    private long lifeTime = 0L;

    public Pdu(int commandId, String name, boolean isRequest) {
        this.name = name;
        this.isRequest = isRequest;
        this.commandLength = null;
        this.commandId = commandId;
        this.sequenceNumber = (int)DefaultSequenceNumberUtil.getSequenceNo();
        this.referenceObject = null;
    }

    public void setReferenceObject(Object value) {
        this.referenceObject = value;
    }

    public Object getReferenceObject() {
        return this.referenceObject;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isRequest() {
        return this.isRequest;
    }

    @Override
    public boolean isResponse() {
        return !this.isRequest;
    }

    public boolean hasCommandLengthCalculated() {
        return this.commandLength != null;
    }

    public void removeCommandLength() {
        this.commandLength = null;
    }

    public void setCommandLength(int value) {
        this.commandLength = new Integer(value);
    }

    public int getCommandLength() {
        if (this.commandLength == null) {
            return 0;
        }
        return this.commandLength;
    }

    public int calculateAndSetCommandLength() {
        int len = 16 + this.calculateByteSizeOfBody() + this.calculateByteSizeOfOptionalParameters();
        this.setCommandLength(len);
        return len;
    }

    public int getCommandId() {
        return this.commandId;
    }

    public void setCommandStatus(int value) {
        this.commandStatus = value;
    }

    public int getCommandStatus() {
        return this.commandStatus;
    }

    public boolean hasSequenceNumberAssigned() {
        return this.sequenceNumber != null;
    }

    public void removeSequenceNumber() {
        this.sequenceNumber = null;
    }

    public void setSequenceNumber(int value) {
        this.sequenceNumber = new Integer(value);
    }

    public int getSequenceNumber() {
        if (this.sequenceNumber == null) {
            return 0;
        }
        return this.sequenceNumber;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public void setLifeTime(long lifeTime) {
        this.lifeTime = lifeTime;
    }

    @Override
    public boolean isTerminated() {
        return this.lifeTime != 0L && this.timestamp + this.lifeTime * 1000L - CachedMillisecondClock.INS.now() < 0L;
    }

    public int getOptionalParameterCount() {
        if (this.optionalParameters == null) {
            return 0;
        }
        return this.optionalParameters.size();
    }

    public ArrayList<Tlv> getOptionalParameters() {
        return this.optionalParameters;
    }

    public void addOptionalParameter(Tlv tlv) {
        if (this.optionalParameters == null) {
            this.optionalParameters = new ArrayList();
        }
        this.optionalParameters.add(tlv);
    }

    public Tlv removeOptionalParameter(short tag) {
        int i = this.findOptionalParameter(tag);
        if (i < 0) {
            return null;
        }
        return this.optionalParameters.remove(i);
    }

    public Tlv setOptionalParameter(Tlv tlv) {
        int i = this.findOptionalParameter(tlv.getTag());
        if (i < 0) {
            this.addOptionalParameter(tlv);
            return null;
        }
        return this.optionalParameters.set(i, tlv);
    }

    public boolean hasOptionalParameter(short tag) {
        return this.findOptionalParameter(tag) >= 0;
    }

    protected int findOptionalParameter(short tag) {
        if (this.optionalParameters == null) {
            return -1;
        }
        int i = 0;
        for (Tlv tlv : this.optionalParameters) {
            if (tlv.getTag() == tag) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Tlv getOptionalParameter(short tag) {
        if (this.optionalParameters == null) {
            return null;
        }
        int i = this.findOptionalParameter(tag);
        if (i < 0) {
            return null;
        }
        return this.optionalParameters.get(i);
    }

    protected abstract int calculateByteSizeOfBody();

    public abstract void readBody(ByteBuf var1) throws UnrecoverablePduException, RecoverablePduException;

    public abstract void writeBody(ByteBuf var1) throws UnrecoverablePduException, RecoverablePduException;

    protected abstract void appendBodyToString(StringBuilder var1);

    protected int calculateByteSizeOfOptionalParameters() {
        if (this.optionalParameters == null) {
            return 0;
        }
        int optParamLength = 0;
        for (Tlv tlv : this.optionalParameters) {
            optParamLength += tlv.calculateByteSize();
        }
        return optParamLength;
    }

    public void readOptionalParameters(ByteBuf buffer, PduTranscoderContext context) throws UnrecoverablePduException, RecoverablePduException {
        while (buffer.readableBytes() > 0) {
            Tlv tlv = ByteBufUtil.readTlv(buffer);
            if (tlv.getTagName() == null) {
                tlv.setTagName(context.lookupTlvTagName(tlv.getTag()));
            }
            this.addOptionalParameter(tlv);
        }
    }

    public void writeOptionalParameters(ByteBuf buffer, PduTranscoderContext context) throws UnrecoverablePduException, RecoverablePduException {
        if (this.optionalParameters == null) {
            return;
        }
        for (Tlv tlv : this.optionalParameters) {
            if (tlv.getTagName() == null) {
                tlv.setTagName(context.lookupTlvTagName(tlv.getTag()));
            }
            ByteBufUtil.writeTlv(buffer, tlv);
        }
    }

    protected void appendOptionalParameterToString(StringBuilder buffer) {
        if (this.optionalParameters == null) {
            return;
        }
        int i = 0;
        for (Tlv tlv : this.optionalParameters) {
            if (i != 0) {
                buffer.append(" (");
            } else {
                buffer.append("(");
            }
            buffer.append(tlv.toString());
            buffer.append(")");
            ++i;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(365 + this.getOptionalParameterCount() * 20);
        buffer.append("(");
        buffer.append(this.name);
        buffer.append(": 0x");
        buffer.append(HexUtil.toHexString(this.getCommandLength()));
        buffer.append(" 0x");
        buffer.append(HexUtil.toHexString(this.commandId));
        buffer.append(" 0x");
        buffer.append(HexUtil.toHexString(this.commandStatus));
        buffer.append(" 0x");
        buffer.append(HexUtil.toHexString(this.getSequenceNumber()));
        if (this instanceof PduResponse) {
            PduResponse response = (PduResponse)this;
            String statusMessage = response.getResultMessage();
            if (statusMessage != null) {
                buffer.append(" result: \"");
                buffer.append(statusMessage);
                buffer.append("\"");
            } else {
                buffer.append(" result: <unmapped>");
            }
        }
        buffer.append(")");
        buffer.append(" (body: ");
        this.appendBodyToString(buffer);
        buffer.append(") (opts: ");
        this.appendOptionalParameterToString(buffer);
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public long getSequenceNo() {
        return this.getSequenceNumber();
    }

    @Override
    public void setSequenceNo(long seq) {
        this.setSequenceNumber((int)seq);
    }
}

