/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.common.storedMap;

import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.collections.StoredMap;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.zx.sms.common.storedMap.FstSerialBinding;
import com.zx.sms.common.storedMap.StoredMapFactory;
import com.zx.sms.common.storedMap.VersionObject;
import com.zx.sms.config.PropertiesUtils;
import com.zx.sms.connect.manager.EventLoopGroupFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BDBStoredMapFactoryImpl implements StoredMapFactory<Serializable, VersionObject>
{
    INS;

    private static final Logger logger;
    private final ConcurrentHashMap<String, QueueEnvironment> envMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, StoredMap<Serializable, VersionObject>> storedMaps = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, StoredSortedMap<Long, Serializable>> sortedstoredMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, BlockingQueue<Serializable>> queueMap = new ConcurrentHashMap();

    static {
        logger = LoggerFactory.getLogger(BDBStoredMapFactoryImpl.class);
    }

    @Override
    public synchronized ConcurrentMap<Serializable, VersionObject> buildMap(String storedpath, String name) {
        QueueEnvironment env = this.buildBDB(storedpath);
        FstSerialBinding messageKeyBinding = new FstSerialBinding();
        FstSerialBinding messageValueBinding = new FstSerialBinding();
        Database db = env.buildDatabase(name);
        String keyName = storedpath + name;
        StoredMap<Serializable, VersionObject> map = this.storedMaps.get(keyName);
        if (map == null) {
            StoredMap<Serializable, VersionObject> tmpMap = new StoredMap<Serializable, VersionObject>(db, messageKeyBinding, messageValueBinding, true);
            StoredMap<Serializable, VersionObject> old = this.storedMaps.putIfAbsent(keyName, tmpMap);
            return old == null ? tmpMap : old;
        }
        return map;
    }

    private StoredSortedMap<Long, Serializable> buildStoredSortedMap(String storedpath, String name) {
        QueueEnvironment env = this.buildBDB(storedpath);
        FstSerialBinding messageKeyBinding = new FstSerialBinding();
        FstSerialBinding messageValueBinding = new FstSerialBinding();
        Database db = env.buildDatabase(name);
        String keyName = storedpath + name;
        StoredSortedMap<Long, Serializable> soredMap = this.sortedstoredMap.get(keyName);
        if (soredMap == null) {
            soredMap = new StoredSortedMap<Long, Serializable>(db, messageKeyBinding, messageValueBinding, true);
            StoredSortedMap<Long, Serializable> old = this.sortedstoredMap.putIfAbsent(keyName, soredMap);
            return old == null ? soredMap : old;
        }
        return soredMap;
    }

    private QueueEnvironment buildBDB(String basename) {
        boolean succ;
        basename = basename == null ? "" : basename;
        String pathName = PropertiesUtils.globalBDBBaseHome.endsWith("/") ? String.valueOf(PropertiesUtils.globalBDBBaseHome) + basename : String.valueOf(PropertiesUtils.globalBDBBaseHome) + "/" + basename;
        File file = new File(pathName);
        if (!file.exists() && !(succ = file.mkdirs())) {
            logger.error("create Directory {} failed. ", (Object)pathName);
            return null;
        }
        if (!file.isDirectory()) {
            logger.error("file  {} is not a Directory ", (Object)pathName);
            return null;
        }
        QueueEnvironment env = this.envMap.get(pathName);
        if (env == null) {
            logger.info("init BDBPath : {}", (Object)pathName);
            env = new QueueEnvironment().buildEnvironment(pathName).buildStoredClassCatalog();
            QueueEnvironment oldenv = this.envMap.putIfAbsent(pathName, env);
            return oldenv == null ? env : oldenv;
        }
        return env;
    }

    private class QueueEnvironment {
        private Environment environment;
        private DatabaseConfig dbConfig;
        private Database classCatalogDB;
        private StoredClassCatalog storedClassCatalog;
        private ConcurrentHashMap<String, Database> dbMap = new ConcurrentHashMap();

        private QueueEnvironment() {
        }

        public QueueEnvironment buildEnvironment(String pathHome) {
            File home = new File(pathHome);
            EnvironmentConfig environmentConfig = new EnvironmentConfig(PropertiesUtils.getJeProperties());
            environmentConfig.setAllowCreate(true);
            environmentConfig.setTransactional(true);
            this.environment = new Environment(home, environmentConfig);
            this.dbConfig = new DatabaseConfig();
            this.dbConfig.setAllowCreate(true);
            this.dbConfig.setTransactional(true);
            this.cleanLogSchedule();
            return this;
        }

        public QueueEnvironment buildStoredClassCatalog() {
            return this.buildStoredClassCatalog("classCatalog");
        }

        public QueueEnvironment buildStoredClassCatalog(String Name) {
            this.classCatalogDB = this.environment.openDatabase(null, Name, this.dbConfig);
            this.storedClassCatalog = new StoredClassCatalog(this.classCatalogDB);
            return this;
        }

        public Database buildDatabase(String queueName) {
            Database queueDB = this.dbMap.get(queueName);
            if (queueDB == null) {
                queueDB = this.environment.openDatabase(null, queueName, this.dbConfig);
                Database olddb = this.dbMap.putIfAbsent(queueName, queueDB);
                return olddb == null ? queueDB : olddb;
            }
            return queueDB;
        }

        public void clearLog() {
            this.environment.cleanLog();
        }

        public void close() {
            this.environment.cleanLog();
            this.classCatalogDB.close();
            this.closeAllQueue();
            this.environment.close();
        }

        private synchronized void closeAllQueue() {
            for (Map.Entry<String, Database> entry : this.dbMap.entrySet()) {
                entry.getValue().close();
            }
        }

        public StoredClassCatalog getStoredClassCatalog() {
            return this.storedClassCatalog;
        }

        private Properties loadFrompropertiesFile(File file) {
            Properties tmpProperties = new Properties();
            FileInputStream in = null;
            try {
                try {
                    in = FileUtils.openInputStream((File)file);
                    tmpProperties.load(in);
                }
                catch (Exception ex) {
                    logger.error("load je.properties error.", (Throwable)ex);
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            return tmpProperties;
        }

        private void cleanLogSchedule() {
            EventLoopGroupFactory.INS.getBusiWork().scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    QueueEnvironment.this.clearLog();
                }
            }, 60L, 60L, TimeUnit.SECONDS);
        }
    }
}

