/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.common.util;

import com.google.common.base.Preconditions;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.util.StandardCharsets;
import java.nio.charset.Charset;
import org.marre.sms.SmsAlphabet;
import org.marre.sms.SmsTextMessage;

public final class CMPPCommonUtil {
    public static byte[] ensureLength(byte[] array, int minLength, int padding) {
        Preconditions.checkArgument((minLength >= 0 ? 1 : 0) != 0, (String)"Invalid minLength: %s", (Object[])new Object[]{minLength});
        Preconditions.checkArgument((padding >= 0 ? 1 : 0) != 0, (String)"Invalid padding: %s", (Object[])new Object[]{padding});
        if (array.length == minLength) {
            return array;
        }
        return array.length > minLength ? CMPPCommonUtil.copyOf(array, minLength) : CMPPCommonUtil.copyOf(array, minLength + padding);
    }

    private static byte[] copyOf(byte[] original, int length) {
        byte[] copy = new byte[length];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, length));
        return copy;
    }

    public static SmsTextMessage buildTextMessage(String text) {
        return new SmsTextMessage(text);
    }

    public static Charset switchCharset(SmsAlphabet type) {
        switch (type) {
            case ASCII: {
                return StandardCharsets.ISO_8859_1;
            }
            case LATIN1: {
                return StandardCharsets.ISO_8859_1;
            }
            case UCS2: {
                return Charset.forName("ISO-10646-UCS-2");
            }
            case RESERVED: {
                return Charset.forName("GBK");
            }
        }
        return GlobalConstance.defaultTransportCharset;
    }
}

