/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.common.util;

import com.zx.sms.BaseMessage;
import com.zx.sms.LongSMSMessage;
import com.zx.sms.codec.cmpp.wap.LongMessageFrame;
import com.zx.sms.codec.cmpp.wap.LongMessageFrameHolder;
import com.zx.sms.connect.manager.EndpointConnector;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.EndpointManager;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.ArrayList;
import java.util.List;
import org.marre.sms.SmsMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelUtil {
    private static final Logger logger = LoggerFactory.getLogger(ChannelUtil.class);

    public static ChannelFuture asyncWriteToEntity(EndpointEntity entity, Object msg) {
        EndpointConnector<?> connector = EndpointManager.INS.getEndpointConnector(entity);
        return ChannelUtil.asyncWriteToEntity(connector, msg, null);
    }

    public static ChannelFuture asyncWriteToEntity(String entity, Object msg) {
        EndpointConnector<?> connector = EndpointManager.INS.getEndpointConnector(entity);
        return ChannelUtil.asyncWriteToEntity(connector, msg, null);
    }

    public static ChannelFuture asyncWriteToEntity(EndpointEntity entity, Object msg, GenericFutureListener listner) {
        EndpointConnector<?> connector = EndpointManager.INS.getEndpointConnector(entity);
        return ChannelUtil.asyncWriteToEntity(connector, msg, listner);
    }

    public static ChannelFuture asyncWriteToEntity(String entity, Object msg, GenericFutureListener listner) {
        EndpointConnector<?> connector = EndpointManager.INS.getEndpointConnector(entity);
        return ChannelUtil.asyncWriteToEntity(connector, msg, listner);
    }

    private static ChannelFuture asyncWriteToEntity(EndpointConnector connector, final Object msg, GenericFutureListener listner) {
        if (connector == null || msg == null) {
            return null;
        }
        ChannelFuture promise = connector.asynwrite(msg);
        if (promise == null) {
            return null;
        }
        if (listner == null) {
            promise.addListener(new GenericFutureListener(){

                public void operationComplete(Future future) throws Exception {
                    if (!future.isSuccess()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("SendMessage ").append(msg.toString()).append(" Failed. ");
                        logger.error(sb.toString(), future.cause());
                    }
                }
            });
        } else {
            promise.addListener(listner);
        }
        return promise;
    }

    public static <T extends BaseMessage> List<Promise<T>> syncWriteLongMsgToEntity(String entity, BaseMessage msg) throws Exception {
        LongSMSMessage lmsg;
        EndpointConnector<?> connector = EndpointManager.INS.getEndpointConnector(entity);
        if (msg instanceof LongSMSMessage && !(lmsg = (LongSMSMessage)((Object)msg)).isReport()) {
            SmsMessage msgcontent = lmsg.getSmsMessage();
            List<LongMessageFrame> frameList = LongMessageFrameHolder.INS.splitmsgcontent(msgcontent);
            ArrayList<BaseMessage> msgs = new ArrayList<BaseMessage>();
            for (LongMessageFrame frame : frameList) {
                BaseMessage basemsg = (BaseMessage)lmsg.generateMessage(frame);
                msgs.add(basemsg);
            }
            return connector.synwrite(msgs);
        }
        Promise<BaseMessage> promise = connector.synwrite(msg);
        if (promise == null) {
            return null;
        }
        ArrayList<Promise<T>> arrPromise = new ArrayList<Promise<T>>();
        arrPromise.add(promise);
        return arrPromise;
    }

    public static <T extends BaseMessage> Promise<T> syncWriteBinaryMsgToEntity(String entity, BaseMessage msg) throws Exception {
        EndpointConnector<?> connector = EndpointManager.INS.getEndpointConnector(entity);
        Promise<BaseMessage> promise = connector.synwrite(msg);
        if (promise == null) {
            return null;
        }
        return promise;
    }
}

