/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.common.util;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConsistentHash<T> {
    private final Collection<T> nodes;
    private final HashFunction hashFunction;
    private final int numberOfReplicas;
    private final SortedMap<Long, T> circle = new TreeMap<Long, T>();

    public ConsistentHash(Collection<T> nodes) {
        this(Hashing.md5(), 100, nodes);
    }

    public ConsistentHash(HashFunction hashFunction, int numberOfReplicas, Collection<T> nodes) {
        this.nodes = nodes;
        this.hashFunction = hashFunction;
        this.numberOfReplicas = numberOfReplicas;
        for (T node : nodes) {
            this.add(node);
        }
    }

    public void add(T node) {
        int i = 0;
        while (i < this.numberOfReplicas) {
            this.circle.put(this.hashFunction.hashString((CharSequence)(String.valueOf(node.toString()) + i), Charset.defaultCharset()).asLong(), node);
            ++i;
        }
    }

    public void delete(T node) {
        int i = 0;
        while (i < this.numberOfReplicas) {
            this.circle.remove(this.hashFunction.hashString((CharSequence)(String.valueOf(node.toString()) + i), Charset.defaultCharset()).asLong());
            ++i;
        }
    }

    public T get(Object key) {
        if (this.circle.isEmpty()) {
            return null;
        }
        Long hash = this.hashFunction.hashString((CharSequence)key.toString(), Charset.defaultCharset()).asLong();
        if (!this.circle.containsKey(hash)) {
            SortedMap<Long, T> tailMap = this.circle.tailMap(hash);
            hash = tailMap.isEmpty() ? this.circle.firstKey() : tailMap.firstKey();
        }
        return (T)this.circle.get(hash);
    }

    public Collection<T> getNodes() {
        return this.nodes;
    }
}

