/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.common.util;

import com.zx.sms.codec.cmpp.packet.CmppCancelRequest;
import com.zx.sms.common.util.MsgId;
import java.nio.ByteBuffer;

public final class DefaultMsgIdUtil {
    public static byte[] msgId2Bytes(MsgId msgId) {
        byte[] bytes = new byte[CmppCancelRequest.MSGID.getLength()];
        long result = 0L;
        if (msgId != null) {
            result |= (long)msgId.getMonth() << 60;
            result |= (long)msgId.getDay() << 55;
            result |= (long)msgId.getHour() << 50;
            result |= (long)msgId.getMinutes() << 44;
            result |= (long)msgId.getSeconds() << 38;
            result |= (long)msgId.getGateId() << 16;
            result |= (long)msgId.getSequenceId() & 0xFFFFL;
        }
        ByteBuffer.wrap(bytes).putLong(result);
        return bytes;
    }

    public static MsgId bytes2MsgId(byte[] bytes) {
        assert (bytes.length == CmppCancelRequest.MSGID.getLength());
        long result = ByteBuffer.wrap(bytes).getLong();
        MsgId msgId = new MsgId();
        msgId.setMonth((int)(result >>> 60 & 0xFL));
        msgId.setDay((int)(result >>> 55 & 0x1FL));
        msgId.setHour((int)(result >>> 50 & 0x1FL));
        msgId.setMinutes((int)(result >>> 44 & 0x3FL));
        msgId.setSeconds((int)(result >>> 38 & 0x3FL));
        msgId.setGateId((int)(result >>> 16 & 0x3FFFFFL));
        msgId.setSequenceId((int)(result & 0xFFFFL));
        return msgId;
    }
}

