/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.common.util;

import com.zx.sms.common.util.CachedMillisecondClock;
import com.zx.sms.common.util.SequenceNumber;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DefaultSequenceNumberUtil {
    private static final String[] datePattern = new String[]{"yyyyMMddHHmmss"};
    private static final long Limited = 0x7FFFFFFFFFFF0000L;
    private static final AtomicLong sequenceId = new AtomicLong(Math.abs(RandomUtils.nextInt()));

    public static byte[] sequenceN2Bytes(SequenceNumber sn) {
        byte[] bytes = new byte[12];
        long t = Long.parseLong(sn.getTimeString());
        ByteBuffer.wrap(bytes).putInt((int)sn.getNodeIds()).putInt((int)t).putInt((int)sn.getSequenceId());
        return bytes;
    }

    public static SequenceNumber bytes2SequenceN(byte[] bytes) {
        Date d;
        long nodeIds = (long)ByteBuffer.wrap(Arrays.copyOfRange(bytes, 0, 4)).getInt() & 0xFFFFFFFFL;
        String year = DateFormatUtils.format((long)CachedMillisecondClock.INS.now(), (String)"yyyy");
        String t = String.format("%1$s%2$010d", year, (long)ByteBuffer.wrap(Arrays.copyOfRange(bytes, 4, 8)).getInt() & 0xFFFFFFFFL);
        try {
            d = DateUtils.parseDate((String)t, (String[])datePattern);
            if (d.getTime() - CachedMillisecondClock.INS.now() > 17280000000L) {
                d = DateUtils.addYears((Date)d, (int)-1);
            }
        }
        catch (ParseException e) {
            d = new Date();
            e.printStackTrace();
        }
        long sequenceId = (long)ByteBuffer.wrap(Arrays.copyOfRange(bytes, 8, 12)).getInt() & 0xFFFFFFFFL;
        SequenceNumber sn = new SequenceNumber(d.getTime(), nodeIds, sequenceId);
        return sn;
    }

    public static long getSequenceNo() {
        return DefaultSequenceNumberUtil.getNextAtomicValue(sequenceId, 0x7FFFFFFFFFFF0000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNextAtomicValue(AtomicLong atomicObj, long limited) {
        long ret = atomicObj.getAndIncrement();
        if (ret > limited) {
            AtomicLong atomicLong = atomicObj;
            synchronized (atomicLong) {
                block5: {
                    if (atomicObj.get() <= limited) break block5;
                    atomicObj.set(0L);
                    return 0L;
                }
                return atomicObj.getAndIncrement();
            }
        }
        return ret;
    }
}

