/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.common.util;

import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public abstract class FstObjectSerializeUtil {
    private static final ThreadLocal<FSTConfiguration> conf = new ThreadLocal<FSTConfiguration>(){

        @Override
        public FSTConfiguration initialValue() {
            return FSTConfiguration.createDefaultConfiguration();
        }
    };

    public static byte[] write(Serializable obj) throws Exception {
        ByteArrayOutputStream arroutput = new ByteArrayOutputStream();
        FSTObjectOutput objoutput = conf.get().getObjectOutput((OutputStream)arroutput);
        try {
            objoutput.writeObject((Object)obj);
            objoutput.flush();
            byte[] byArray = arroutput.toByteArray();
            return byArray;
        }
        finally {
            arroutput.close();
        }
    }

    public static Serializable read(byte[] bytes) throws Exception {
        FSTObjectInput objinput = conf.get().getObjectInput(bytes);
        try {
            Object t = objinput.readObject();
            if (t instanceof Serializable) {
                return (Serializable)t;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

