/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.common.util;

public class HexUtil {
    public static char[] HEX_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        return HexUtil.toHexString(bytes, 0, bytes.length);
    }

    public static String toHexString(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            return "";
        }
        HexUtil.assertOffsetLengthValid(offset, length, bytes.length);
        StringBuilder buffer = new StringBuilder(length * 2);
        HexUtil.appendHexString(buffer, bytes, offset, length);
        return buffer.toString();
    }

    public static void appendHexString(StringBuilder buffer, byte[] bytes) {
        HexUtil.assertNotNull(buffer);
        if (bytes == null) {
            return;
        }
        HexUtil.appendHexString(buffer, bytes, 0, bytes.length);
    }

    public static void appendHexString(StringBuilder buffer, byte[] bytes, int offset, int length) {
        HexUtil.assertNotNull(buffer);
        if (bytes == null) {
            return;
        }
        HexUtil.assertOffsetLengthValid(offset, length, bytes.length);
        int end = offset + length;
        int i = offset;
        while (i < end) {
            int nibble1 = (bytes[i] & 0xF0) >>> 4;
            int nibble0 = bytes[i] & 0xF;
            buffer.append(HEX_TABLE[nibble1]);
            buffer.append(HEX_TABLE[nibble0]);
            ++i;
        }
    }

    public static String toHexString(byte value) {
        StringBuilder buffer = new StringBuilder(2);
        HexUtil.appendHexString(buffer, value);
        return buffer.toString();
    }

    public static void appendHexString(StringBuilder buffer, byte value) {
        HexUtil.assertNotNull(buffer);
        int nibble = (value & 0xF0) >>> 4;
        buffer.append(HEX_TABLE[nibble]);
        nibble = value & 0xF;
        buffer.append(HEX_TABLE[nibble]);
    }

    public static String toHexString(short value) {
        StringBuilder buffer = new StringBuilder(4);
        HexUtil.appendHexString(buffer, value);
        return buffer.toString();
    }

    public static void appendHexString(StringBuilder buffer, short value) {
        HexUtil.assertNotNull(buffer);
        int nibble = (value & 0xF000) >>> 12;
        buffer.append(HEX_TABLE[nibble]);
        nibble = (value & 0xF00) >>> 8;
        buffer.append(HEX_TABLE[nibble]);
        nibble = (value & 0xF0) >>> 4;
        buffer.append(HEX_TABLE[nibble]);
        nibble = value & 0xF;
        buffer.append(HEX_TABLE[nibble]);
    }

    public static String toHexString(int value) {
        StringBuilder buffer = new StringBuilder(8);
        HexUtil.appendHexString(buffer, value);
        return buffer.toString();
    }

    public static void appendHexString(StringBuilder buffer, int value) {
        HexUtil.assertNotNull(buffer);
        int nibble = (value & 0xF0000000) >>> 28;
        buffer.append(HEX_TABLE[nibble]);
        nibble = (value & 0xF000000) >>> 24;
        buffer.append(HEX_TABLE[nibble]);
        nibble = (value & 0xF00000) >>> 20;
        buffer.append(HEX_TABLE[nibble]);
        nibble = (value & 0xF0000) >>> 16;
        buffer.append(HEX_TABLE[nibble]);
        nibble = (value & 0xF000) >>> 12;
        buffer.append(HEX_TABLE[nibble]);
        nibble = (value & 0xF00) >>> 8;
        buffer.append(HEX_TABLE[nibble]);
        nibble = (value & 0xF0) >>> 4;
        buffer.append(HEX_TABLE[nibble]);
        nibble = value & 0xF;
        buffer.append(HEX_TABLE[nibble]);
    }

    public static String toHexString(long value) {
        StringBuilder buffer = new StringBuilder(16);
        HexUtil.appendHexString(buffer, value);
        return buffer.toString();
    }

    public static void appendHexString(StringBuilder buffer, long value) {
        HexUtil.appendHexString(buffer, (int)((value & 0xFFFFFFFF00000000L) >>> 32));
        HexUtil.appendHexString(buffer, (int)(value & 0xFFFFFFFFL));
    }

    private static void assertNotNull(StringBuilder buffer) {
        if (buffer == null) {
            throw new NullPointerException("The buffer cannot be null");
        }
    }

    private static void assertOffsetLengthValid(int offset, int length, int arrayLength) {
        if (offset < 0) {
            throw new IllegalArgumentException("The array offset was negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("The array length was negative");
        }
        if (offset + length > arrayLength) {
            throw new ArrayIndexOutOfBoundsException("The array offset+length would access past end of array");
        }
    }

    public static int hexCharToIntValue(char c) {
        if (c == '0') {
            return 0;
        }
        if (c == '1') {
            return 1;
        }
        if (c == '2') {
            return 2;
        }
        if (c == '3') {
            return 3;
        }
        if (c == '4') {
            return 4;
        }
        if (c == '5') {
            return 5;
        }
        if (c == '6') {
            return 6;
        }
        if (c == '7') {
            return 7;
        }
        if (c == '8') {
            return 8;
        }
        if (c == '9') {
            return 9;
        }
        if (c == 'A' || c == 'a') {
            return 10;
        }
        if (c == 'B' || c == 'b') {
            return 11;
        }
        if (c == 'C' || c == 'c') {
            return 12;
        }
        if (c == 'D' || c == 'd') {
            return 13;
        }
        if (c == 'E' || c == 'e') {
            return 14;
        }
        if (c == 'F' || c == 'f') {
            return 15;
        }
        throw new IllegalArgumentException("The character [" + c + "] does not represent a valid hex digit");
    }

    public static byte[] toByteArray(CharSequence hexString) {
        if (hexString == null) {
            return null;
        }
        return HexUtil.toByteArray(hexString, 0, hexString.length());
    }

    public static byte[] toByteArray(CharSequence hexString, int offset, int length) {
        if (hexString == null) {
            return null;
        }
        HexUtil.assertOffsetLengthValid(offset, length, hexString.length());
        if (length % 2 != 0) {
            throw new IllegalArgumentException("The hex string did not contain an even number of characters [actual=" + length + "]");
        }
        byte[] bytes = new byte[length / 2];
        int j = 0;
        int end = offset + length;
        int i = offset;
        while (i < end) {
            int highNibble = HexUtil.hexCharToIntValue(hexString.charAt(i));
            int lowNibble = HexUtil.hexCharToIntValue(hexString.charAt(i + 1));
            bytes[j++] = (byte)(highNibble << 4 & 0xF0 | lowNibble & 0xF);
            i += 2;
        }
        return bytes;
    }
}

