/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.common.util;

import com.zx.sms.common.util.CachedMillisecondClock;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import com.zx.sms.common.util.MsgId;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class SequenceNumber
implements Serializable {
    private static final long serialVersionUID = 650229326111998772L;
    private static final String[] datePattern = new String[]{"yyyyMMddHHmmss"};
    private long nodeIds;
    private long sequenceId;
    private long timestamp;

    public SequenceNumber() {
        this(CachedMillisecondClock.INS.now());
    }

    public SequenceNumber(long nodeIds, long timeMillis) {
        this(timeMillis, nodeIds, DefaultSequenceNumberUtil.getSequenceNo());
    }

    public SequenceNumber(long timeMillis) {
        this(timeMillis, 1010L, DefaultSequenceNumberUtil.getSequenceNo());
    }

    public SequenceNumber(MsgId msgIds) {
        Date d;
        String strmsgid = msgIds.toString();
        this.setNodeIds(msgIds.getGateId());
        String year = DateFormatUtils.format((long)CachedMillisecondClock.INS.now(), (String)"yyyy");
        String t = String.format("%1$s%2$s", year, strmsgid.substring(0, 10));
        try {
            d = DateUtils.parseDate((String)t, (String[])datePattern);
            if (d.getTime() - CachedMillisecondClock.INS.now() > 17280000000L) {
                d = DateUtils.addYears((Date)d, (int)-1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            d = new Date();
        }
        this.setTimestamp(d.getTime());
        this.setSequenceId(msgIds.getSequenceId());
    }

    public SequenceNumber(long timeMillis, long nodeIds, long sequenceId) {
        this.setNodeIds(nodeIds);
        this.setSequenceId(sequenceId);
        this.setTimestamp(timeMillis);
    }

    public long getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(long nodeIds) {
        this.nodeIds = nodeIds;
    }

    public long getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(long sequenceId) {
        this.sequenceId = sequenceId;
    }

    public String getTimeString() {
        return DateFormatUtils.format((long)this.timestamp, (String)"MMddHHmmss");
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String toString() {
        return String.format("%1$010d%2$10s%3$010d", this.nodeIds, this.getTimeString(), this.sequenceId);
    }
}

