/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class PropertiesUtils {
    private static final Properties global = PropertiesUtils.loadProperties("global.properties");
    private static final Properties je = PropertiesUtils.loadProperties("je.properties");
    public static String globalBDBBaseHome = PropertiesUtils.getproperties("BDBBaseHome", System.getProperty("java.io.tmpdir"));

    public static String getdefaultTransportCharset() {
        String charset = global.getProperty("defaultTransportCharset");
        return charset == null ? "UTF-8" : charset;
    }

    public static String getproperties(String key, String defaultValue) {
        String ret = global.getProperty(key);
        return StringUtils.isBlank((CharSequence)ret) ? defaultValue : ret;
    }

    public static Properties getJeProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)je);
        return properties;
    }

    private static Properties loadProperties(String resources) {
        InputStream inputstream = PropertiesUtils.class.getClassLoader().getResourceAsStream(resources);
        Properties properties = new Properties();
        if (inputstream == null) {
            return properties;
        }
        try {
            properties.load(inputstream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                inputstream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

