/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.connect.manager;

import com.zx.sms.BaseMessage;
import com.zx.sms.common.GlobalConstance;
import com.zx.sms.common.NotSupportedException;
import com.zx.sms.common.storedMap.BDBStoredMapFactoryImpl;
import com.zx.sms.common.util.DefaultSequenceNumberUtil;
import com.zx.sms.connect.manager.ClientEndpoint;
import com.zx.sms.connect.manager.EndpointConnector;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.cmpp.CMPPServerEndpointEntity;
import com.zx.sms.handler.MessageLogHandler;
import com.zx.sms.handler.api.AbstractBusinessHandler;
import com.zx.sms.handler.api.BusinessHandlerInterface;
import com.zx.sms.session.AbstractSessionStateManager;
import com.zx.sms.session.cmpp.SessionState;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.traffic.ChannelTrafficShapingHandler;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEndpointConnector
implements EndpointConnector<EndpointEntity> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEndpointConnector.class);
    private volatile AtomicInteger conCnt = new AtomicInteger();
    private SslContext sslCtx = null;
    private EndpointEntity endpoint;
    private CircularList channels = new CircularList();
    private static final String sessionHandler = "sessionStateManager";

    public AbstractEndpointConnector(EndpointEntity endpoint) {
        this.endpoint = endpoint;
        this.sslCtx = this.createSslCtx();
    }

    protected abstract SslContext createSslCtx();

    @Override
    public EndpointEntity getEndpointEntity() {
        return this.endpoint;
    }

    @Override
    public void close(Channel channel) throws Exception {
        try {
            if (channel.isOpen()) {
                channel.close().sync();
            }
        }
        catch (InterruptedException e) {
            logger.error("close channel Error ", (Throwable)e);
        }
        this.removeChannel(channel);
    }

    @Override
    public void close() throws Exception {
        Channel ch = this.channels.fetch();
        while (ch != null) {
            this.close(ch);
            ch = this.channels.fetch();
        }
    }

    @Override
    public Channel fetch() {
        Channel ch = this.channels.fetch();
        if (ch != null && ch.isActive() && ch.attr(GlobalConstance.attributeKey).get() == SessionState.Connect) {
            return ch;
        }
        return null;
    }

    public SslContext getSslCtx() {
        return this.sslCtx;
    }

    @Override
    public int getConnectionNum() {
        return this.conCnt.get();
    }

    protected int incrementConn() {
        return this.conCnt.incrementAndGet();
    }

    protected int decrementConn() {
        return this.conCnt.decrementAndGet();
    }

    private CircularList getChannels() {
        return this.channels;
    }

    protected abstract AbstractSessionStateManager createSessionManager(EndpointEntity var1, ConcurrentMap var2, boolean var3);

    protected abstract void doBindHandler(ChannelPipeline var1, EndpointEntity var2);

    protected abstract void doinitPipeLine(ChannelPipeline var1);

    protected void addProxyHandler(Channel ch, URI proxy) throws NotSupportedException {
        int idx;
        if (proxy == null) {
            return;
        }
        String scheme = proxy.getScheme();
        String userinfo = proxy.getUserInfo();
        String host = proxy.getHost();
        int port = proxy.getPort();
        String username = null;
        String pass = null;
        if (userinfo != null && !"".equals(userinfo) && (idx = userinfo.indexOf(":")) > 0) {
            username = userinfo.substring(0, idx);
            pass = userinfo.substring(idx + 1);
        }
        ChannelPipeline pipeline = ch.pipeline();
        if ("HTTP".equalsIgnoreCase(scheme)) {
            if (username == null) {
                pipeline.addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)new InetSocketAddress(host, port))});
            } else {
                pipeline.addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)new InetSocketAddress(host, port), username, pass)});
            }
        } else if ("SOCKS5".equalsIgnoreCase(scheme)) {
            if (username == null) {
                pipeline.addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)new InetSocketAddress(host, port))});
            } else {
                pipeline.addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)new InetSocketAddress(host, port), username, pass)});
            }
        } else if ("SOCKS4".equalsIgnoreCase(scheme)) {
            if (username == null) {
                pipeline.addLast(new ChannelHandler[]{new Socks4ProxyHandler((SocketAddress)new InetSocketAddress(host, port))});
            } else {
                pipeline.addLast(new ChannelHandler[]{new Socks4ProxyHandler((SocketAddress)new InetSocketAddress(host, port), username)});
            }
        } else {
            throw new NotSupportedException("not support proxy protocol " + scheme);
        }
    }

    protected ChannelInitializer<?> initPipeLine() {
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                EndpointEntity entity = AbstractEndpointConnector.this.getEndpointEntity();
                if (entity instanceof ClientEndpoint && entity.getProxy() != null && !"".equals(entity.getProxy())) {
                    String uriString = entity.getProxy();
                    try {
                        URI uri = URI.create(uriString);
                        AbstractEndpointConnector.this.addProxyHandler(ch, uri);
                    }
                    catch (Exception ex) {
                        logger.error("parse Proxy URI failed.", (Throwable)ex);
                    }
                }
                if (entity.isUseSSL() && AbstractEndpointConnector.this.getSslCtx() != null) {
                    AbstractEndpointConnector.this.initSslCtx(ch, entity);
                }
                AbstractEndpointConnector.this.doinitPipeLine(pipeline);
            }
        };
    }

    @Override
    public synchronized boolean addChannel(Channel ch) {
        int nowConnCnt = this.getConnectionNum();
        EndpointEntity endpoint = this.getEndpointEntity();
        if (endpoint.getMaxChannels() == 0 || endpoint.getMaxChannels() > nowConnCnt) {
            ch.attr(GlobalConstance.attributeKey).set((Object)SessionState.Connect);
            this.getChannels().add(ch);
            int cnt = this.incrementConn();
            Map storedMap = null;
            storedMap = endpoint.isReSendFailMsg() ? BDBStoredMapFactoryImpl.INS.buildMap(endpoint.getId(), "Session_" + endpoint.getId()) : new ConcurrentHashMap();
            logger.info("Channel added To Endpoint {} .totalCnt:{} ,remoteAddress: {}", new Object[]{endpoint, cnt, ch.remoteAddress()});
            if (cnt == 1 && endpoint.isReSendFailMsg()) {
                ch.pipeline().addAfter("codecName", sessionHandler, (ChannelHandler)this.createSessionManager(endpoint, (ConcurrentMap)storedMap, true));
            } else {
                ch.pipeline().addAfter("codecName", sessionHandler, (ChannelHandler)this.createSessionManager(endpoint, (ConcurrentMap)storedMap, false));
            }
            ch.pipeline().addAfter("codecName", "ChannelTrafficAfter", (ChannelHandler)new MessageChannelTrafficShapingHandler(endpoint.getWriteLimit(), endpoint.getReadLimit(), 250L));
            this.bindHandler(ch.pipeline(), this.getEndpointEntity());
            return true;
        }
        logger.warn("allowed max channel count: {} ,deny to login.{}", (Object)endpoint.getMaxChannels(), (Object)endpoint);
        return false;
    }

    @Override
    public void removeChannel(Channel ch) {
        if (this.getChannels().remove(ch)) {
            ch.attr(GlobalConstance.attributeKey).set((Object)SessionState.DisConnect);
            this.decrementConn();
        }
    }

    protected void bindHandler(ChannelPipeline pipe, EndpointEntity entity) {
        if (entity instanceof CMPPServerEndpointEntity) {
            return;
        }
        pipe.addFirst("socketLog", (ChannelHandler)new LoggingHandler(String.format("entity.%s", entity.getId()), LogLevel.TRACE));
        this.doBindHandler(pipe, entity);
        pipe.addAfter("codecName", "msgLog", (ChannelHandler)new MessageLogHandler(entity));
        List<BusinessHandlerInterface> handlers = entity.getBusinessHandlerSet();
        if (handlers != null && handlers.size() > 0) {
            for (BusinessHandlerInterface handler : handlers) {
                if (!(handler instanceof AbstractBusinessHandler)) continue;
                AbstractBusinessHandler buziHandler = (AbstractBusinessHandler)handler;
                buziHandler.setEndpointEntity(entity);
                if (buziHandler.isSharable()) {
                    pipe.addLast(buziHandler.name(), (ChannelHandler)buziHandler);
                    continue;
                }
                AbstractBusinessHandler cloned = null;
                try {
                    cloned = buziHandler.clone();
                }
                catch (CloneNotSupportedException e) {
                    logger.error("handlers is not shareable and not implements Cloneable", (Throwable)e);
                }
                if (cloned == null) continue;
                cloned.setEndpointEntity(entity);
                pipe.addLast(buziHandler.name(), (ChannelHandler)cloned);
                logger.info("handlers is not shareable . clone it success. {}", (Object)cloned);
            }
        }
        pipe.addLast("BlackHole", (ChannelHandler)GlobalConstance.blackhole);
    }

    protected abstract void initSslCtx(Channel var1, EndpointEntity var2);

    protected long doCalculateSize(Object msg) {
        if (msg instanceof BaseMessage) {
            BaseMessage req = (BaseMessage)msg;
            if (req.isRequest()) {
                return 1L;
            }
            return 0L;
        }
        return -1L;
    }

    @Override
    public Channel[] getallChannel() {
        return this.channels.getall();
    }

    @Override
    public ChannelFuture asynwrite(Object msg) {
        Channel ch = this.fetchOneWritable();
        if (ch == null) {
            return null;
        }
        ChannelFuture future = ch.writeAndFlush(msg);
        return future;
    }

    @Override
    public <T extends BaseMessage> List<Promise<T>> synwrite(List<T> msgs) {
        Channel ch = this.fetchOneWritable();
        if (ch == null) {
            return null;
        }
        AbstractSessionStateManager session = (AbstractSessionStateManager)ch.pipeline().get(sessionHandler);
        if (session == null) {
            return null;
        }
        ArrayList<Promise<T>> arrPromise = new ArrayList<Promise<T>>();
        for (BaseMessage msg : msgs) {
            arrPromise.add(session.writeMessagesync(msg));
        }
        return arrPromise;
    }

    @Override
    public <T extends BaseMessage> Promise<T> synwrite(T message) {
        Channel ch = this.fetchOneWritable();
        if (ch == null) {
            return null;
        }
        AbstractSessionStateManager session = (AbstractSessionStateManager)ch.pipeline().get(sessionHandler);
        return session.writeMessagesync(message);
    }

    private Channel fetchOneWritable() {
        Channel ch = this.fetch();
        if (ch == null) {
            return null;
        }
        if (ch.isActive() && ch.isWritable()) {
            return ch;
        }
        return null;
    }

    private class CircularList {
        private List<Channel> collection = Collections.synchronizedList(new ArrayList(20));
        private static final long Limited = 65535L;
        private AtomicLong indexSeq = new AtomicLong();

        private CircularList() {
        }

        public Channel[] getall() {
            return this.collection.toArray(new Channel[0]);
        }

        public Channel fetch() {
            int size = AbstractEndpointConnector.this.getConnectionNum();
            if (size == 0) {
                return null;
            }
            int idx = (int)DefaultSequenceNumberUtil.getNextAtomicValue(this.indexSeq, 65535L);
            Channel ret = this.collection.get(idx % size);
            return ret;
        }

        public boolean add(Channel ele) {
            boolean r = false;
            r = this.collection.add(ele);
            return r;
        }

        public boolean remove(Channel ele) {
            boolean r = false;
            r = this.collection.remove(ele);
            return r;
        }
    }

    private class MessageChannelTrafficShapingHandler
    extends ChannelTrafficShapingHandler {
        public MessageChannelTrafficShapingHandler(long writeLimit, long readLimit, long checkInterval) {
            super(writeLimit, readLimit, checkInterval);
            this.setMaxWriteSize(75L);
            this.setMaxWriteDelay(2500L);
        }

        protected long calculateSize(Object msg) {
            if (msg instanceof ByteBuf) {
                return ((ByteBuf)msg).readableBytes();
            }
            if (msg instanceof ByteBufHolder) {
                return ((ByteBufHolder)msg).content().readableBytes();
            }
            return AbstractEndpointConnector.this.doCalculateSize(msg);
        }
    }
}

