/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.connect.manager;

import com.zx.sms.connect.manager.AbstractEndpointConnector;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.EventLoopGroupFactory;
import com.zx.sms.connect.manager.ServerEndpoint;
import com.zx.sms.session.AbstractSessionStateManager;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerEndpointConnector
extends AbstractEndpointConnector {
    private static final Logger logger = LoggerFactory.getLogger(AbstractServerEndpointConnector.class);
    private ServerBootstrap bootstrap = new ServerBootstrap();
    private Channel acceptorChannel = null;

    public AbstractServerEndpointConnector(EndpointEntity e) {
        super(e);
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(EventLoopGroupFactory.INS.getBoss(), EventLoopGroupFactory.INS.getWorker()).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).childOption(ChannelOption.SO_RCVBUF, (Object)2048).childOption(ChannelOption.SO_SNDBUF, (Object)2048).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.TCP_NODELAY, (Object)true).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler(this.initPipeLine());
    }

    @Override
    public ChannelFuture open() throws Exception {
        logger.debug("Open Entity {}", (Object)this.getEndpointEntity());
        ChannelFuture future = null;
        future = this.getEndpointEntity().getHost() == null ? this.bootstrap.bind(this.getEndpointEntity().getPort().intValue()).sync() : this.bootstrap.bind(this.getEndpointEntity().getHost(), this.getEndpointEntity().getPort().intValue()).sync();
        this.acceptorChannel = future.channel();
        return future;
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.acceptorChannel != null) {
            this.acceptorChannel.close();
        }
        this.acceptorChannel = null;
    }

    @Override
    protected SslContext createSslCtx() {
        try {
            if (this.getEndpointEntity().isUseSSL()) {
                SelfSignedCertificate ssc = new SelfSignedCertificate();
                return SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    protected void initSslCtx(Channel ch, EndpointEntity entity) {
        ChannelPipeline pipeline = ch.pipeline();
        if (entity instanceof ServerEndpoint) {
            logger.info("EndpointEntity {} Use SSL.", (Object)entity);
            pipeline.addLast(new ChannelHandler[]{this.getSslCtx().newHandler(ch.alloc())});
        }
    }

    @Override
    protected void doBindHandler(ChannelPipeline pipe, EndpointEntity entity) {
    }

    @Override
    protected AbstractSessionStateManager createSessionManager(EndpointEntity entity, ConcurrentMap storeMap, boolean preSend) {
        return null;
    }
}

