/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.connect.manager;

import com.zx.sms.connect.manager.EndpointConnector;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.EndpointManager;
import com.zx.sms.connect.manager.EndpointManagerInterface;
import com.zx.sms.connect.manager.cmpp.CMPPEndpointEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public enum CMPPEndpointManager implements EndpointManagerInterface
{
    INS;

    private EndpointManager manager = EndpointManager.INS;
    private ConcurrentHashMap<String, List<CMPPEndpointEntity>> groupMap = new ConcurrentHashMap();

    @Override
    public void openEndpoint(EndpointEntity entity) {
        this.manager.openEndpoint(entity);
    }

    @Override
    public void close(EndpointEntity entity) {
        this.manager.close(entity);
    }

    @Override
    public void openAll() throws Exception {
        this.manager.openAll();
    }

    @Override
    public void addEndpointEntity(EndpointEntity entity) {
        this.manager.addEndpointEntity(entity);
        if (entity instanceof CMPPEndpointEntity) {
            CMPPEndpointEntity cmppentity = (CMPPEndpointEntity)entity;
            List<CMPPEndpointEntity> list = this.groupMap.get(cmppentity.getGroupName());
            if (list == null) {
                list = new ArrayList<CMPPEndpointEntity>();
                List<CMPPEndpointEntity> old = this.groupMap.putIfAbsent(cmppentity.getGroupName(), list);
                list = old == null ? list : old;
            }
            list.add(cmppentity);
        }
    }

    @Override
    public Set<EndpointEntity> allEndPointEntity() {
        return this.manager.allEndPointEntity();
    }

    public List<CMPPEndpointEntity> getEndPointEntityByGroup(String group) {
        return this.groupMap.get(group);
    }

    @Override
    public EndpointConnector getEndpointConnector(EndpointEntity entity) {
        return this.manager.getEndpointConnector(entity);
    }

    @Override
    public EndpointConnector getEndpointConnector(String entityId) {
        return this.manager.getEndpointConnector(entityId);
    }

    @Override
    public void remove(String id) {
        this.manager.remove(id);
    }

    @Override
    public EndpointEntity getEndpointEntity(String id) {
        return this.manager.getEndpointEntity(id);
    }

    @Override
    public void addAllEndpointEntity(List<EndpointEntity> entities) {
        if (entities == null || entities.size() == 0) {
            return;
        }
        for (EndpointEntity entity : entities) {
            if (!entity.isValid()) continue;
            this.addEndpointEntity(entity);
        }
    }

    @Override
    public void close() {
        this.manager.close();
    }

    @Override
    public void startConnectionCheckTask() {
        this.manager.startConnectionCheckTask();
    }

    @Override
    public void stopConnectionCheckTask() {
        this.manager.stopConnectionCheckTask();
    }
}

