/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.connect.manager;

import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.zx.sms.config.PropertiesUtils;
import com.zx.sms.connect.manager.ExitUnlimitCirclePolicy;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public enum EventLoopGroupFactory {
    INS;

    private static final RejectedExecutionHandler rejected;
    private static final EventLoopGroup bossGroup;
    private static final EventLoopGroup workgroup;
    private static final ListeningScheduledExecutorService busiWork;

    static {
        rejected = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            }
        };
        bossGroup = new NioEventLoopGroup(1, EventLoopGroupFactory.newThreadFactory("bossGroup"));
        workgroup = new NioEventLoopGroup(0, EventLoopGroupFactory.newThreadFactory("workGroup"));
        busiWork = MoreExecutors.listeningDecorator((ScheduledExecutorService)new ScheduledThreadPoolExecutor(Integer.valueOf(PropertiesUtils.getproperties("GlobalBusiWorkThreadCount", "4")), EventLoopGroupFactory.newThreadFactory("busiWork-"), rejected));
    }

    public EventLoopGroup getBoss() {
        return bossGroup;
    }

    public EventLoopGroup getWorker() {
        return workgroup;
    }

    public ListeningScheduledExecutorService getBusiWork() {
        return busiWork;
    }

    public <T> void submitUnlimitCircleTask(Callable<T> task, ExitUnlimitCirclePolicy<T> exitCondition, long delay) {
        this.addtask(busiWork, task, exitCondition, delay);
    }

    private <T> void addtask(final ListeningScheduledExecutorService executor, final Callable<T> task, final ExitUnlimitCirclePolicy<T> exitCondition, final long delay) {
        if (executor.isShutdown()) {
            return;
        }
        final ListenableScheduledFuture future = executor.schedule(task, delay, TimeUnit.MILLISECONDS);
        future.addListener(new Runnable(){

            @Override
            public void run() {
                DefaultPromise nettyfuture = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
                try {
                    nettyfuture.setSuccess(future.get());
                }
                catch (InterruptedException e) {
                    nettyfuture.tryFailure((Throwable)e);
                }
                catch (ExecutionException e) {
                    nettyfuture.tryFailure((Throwable)e);
                }
                catch (Exception e) {
                    nettyfuture.tryFailure((Throwable)e);
                }
                try {
                    if (exitCondition.notOver(nettyfuture)) {
                        EventLoopGroupFactory.this.addtask(executor, task, exitCondition, delay);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }, (Executor)executor);
    }

    public void closeAll() {
        this.getBusiWork().shutdown();
        this.getBoss().shutdownGracefully().syncUninterruptibly();
        this.getWorker().shutdownGracefully().syncUninterruptibly();
    }

    private static ThreadFactory newThreadFactory(final String name) {
        return new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, String.valueOf(name) + this.threadNumber.getAndIncrement());
                t.setDaemon(true);
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        };
    }
}

