/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.connect.manager.smgp;

import com.zx.sms.common.GlobalConstance;
import com.zx.sms.connect.manager.AbstractClientEndpointConnector;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.smgp.SMGPCodecChannelInitializer;
import com.zx.sms.handler.smgp.SMGPActiveTestMessageHandler;
import com.zx.sms.handler.smgp.SMGPActiveTestRespMessageHandler;
import com.zx.sms.handler.smgp.SMGPDeliverLongMessageHandler;
import com.zx.sms.handler.smgp.SMGPExitMessageHandler;
import com.zx.sms.handler.smgp.SMGPExitRespMessageHandler;
import com.zx.sms.handler.smgp.SMGPSubmitLongMessageHandler;
import com.zx.sms.session.AbstractSessionStateManager;
import com.zx.sms.session.smgp.SMGPSessionLoginManager;
import com.zx.sms.session.smgp.SMGPSessionStateManager;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMGPClientEndpointConnector
extends AbstractClientEndpointConnector {
    private static final Logger logger = LoggerFactory.getLogger(SMGPClientEndpointConnector.class);

    public SMGPClientEndpointConnector(EndpointEntity endpoint) {
        super(endpoint);
    }

    @Override
    protected AbstractSessionStateManager createSessionManager(EndpointEntity entity, ConcurrentMap storeMap, boolean preSend) {
        return new SMGPSessionStateManager(entity, storeMap, preSend);
    }

    @Override
    protected void doBindHandler(ChannelPipeline pipe, EndpointEntity entity) {
        pipe.addLast("SMGPDeliverLongMessageHandler", (ChannelHandler)new SMGPDeliverLongMessageHandler(entity));
        pipe.addLast("SMGPSubmitLongMessageHandler", (ChannelHandler)new SMGPSubmitLongMessageHandler(entity));
        pipe.addLast("SMGPActiveTestMessageHandler", (ChannelHandler)new SMGPActiveTestMessageHandler());
        pipe.addLast("SMGPActiveTestRespMessageHandler", (ChannelHandler)new SMGPActiveTestRespMessageHandler());
        pipe.addLast("SMGPExitRespMessageHandler", (ChannelHandler)new SMGPExitRespMessageHandler());
        pipe.addLast("SMGPExitMessageHandler", (ChannelHandler)new SMGPExitMessageHandler());
    }

    @Override
    protected void doinitPipeLine(ChannelPipeline pipeline) {
        EndpointEntity entity = this.getEndpointEntity();
        pipeline.addLast("IdleStateHandler", (ChannelHandler)new IdleStateHandler(0L, 0L, (long)entity.getIdleTimeSec(), TimeUnit.SECONDS));
        pipeline.addLast("SmgpServerIdleStateHandler", (ChannelHandler)GlobalConstance.smgpidleHandler);
        pipeline.addLast(SMGPCodecChannelInitializer.pipeName(), (ChannelHandler)new SMGPCodecChannelInitializer());
        pipeline.addLast("sessionLoginManager", (ChannelHandler)new SMGPSessionLoginManager(this.getEndpointEntity()));
    }
}

