/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.connect.manager.tcp;

import com.zx.sms.connect.manager.AbstractEndpointConnector;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.EventLoopGroupFactory;
import com.zx.sms.connect.manager.ServerEndpoint;
import com.zx.sms.connect.manager.tcp.TCPClientEndpointEntity;
import com.zx.sms.connect.manager.tcp.TCPServerEchoHandler;
import com.zx.sms.session.AbstractSessionStateManager;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPClientEndpointConnector
extends AbstractEndpointConnector {
    private static final Logger logger = LoggerFactory.getLogger(TCPClientEndpointConnector.class);
    private Bootstrap bootstrap = new Bootstrap();

    public TCPClientEndpointConnector(TCPClientEndpointEntity e) {
        super(e);
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(EventLoopGroupFactory.INS.getWorker())).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_RCVBUF, (Object)2048)).option(ChannelOption.SO_SNDBUF, (Object)2048)).handler(this.initPipeLine());
    }

    @Override
    public ChannelFuture open() throws Exception {
        ChannelFuture future = this.bootstrap.connect(this.getEndpointEntity().getHost(), this.getEndpointEntity().getPort().intValue());
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) throws Exception {
                if (f.isSuccess()) {
                    TCPClientEndpointConnector.this.addChannel(f.channel());
                }
            }
        });
        try {
            future.sync();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return future;
    }

    @Override
    protected SslContext createSslCtx() {
        try {
            if (this.getEndpointEntity().isUseSSL()) {
                return SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    protected void initSslCtx(Channel ch, EndpointEntity entity) {
        ChannelPipeline pipeline = ch.pipeline();
        if (entity.isUseSSL() && entity instanceof ServerEndpoint) {
            pipeline.addLast(new ChannelHandler[]{this.getSslCtx().newHandler(ch.alloc())});
        }
    }

    @Override
    protected void doBindHandler(ChannelPipeline pipe, EndpointEntity entity) {
    }

    @Override
    protected void doinitPipeLine(ChannelPipeline pipeline) {
        pipeline.addLast("clientLog", (ChannelHandler)new LoggingHandler(LogLevel.DEBUG));
        pipeline.addLast("Echo", (ChannelHandler)new TCPServerEchoHandler());
    }

    @Override
    protected AbstractSessionStateManager createSessionManager(EndpointEntity entity, ConcurrentMap storeMap, boolean preSend) {
        return null;
    }
}

