/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.connect.manager.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPServerEchoHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(TCPServerEchoHandler.class);
    private volatile long totalread = 0L;
    private volatile long release = 0L;
    private volatile long trans = 0L;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        int cnt = ((ByteBuf)msg).readableBytes();
        this.totalread += (long)cnt;
        Channel ch = ctx.channel();
        ch.writeAndFlush(msg);
        logger.info("channelID :{} ,read : {}, totalread:{},trans  : {} release {}", new Object[]{ctx.channel(), cnt, this.totalread, this.trans, this.release});
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error("ERROR", cause);
    }

    private static Object safeDuplicate(Object message) {
        if (message instanceof ByteBuf) {
            return ((ByteBuf)message).duplicate().retain();
        }
        if (message instanceof ByteBufHolder) {
            return ((ByteBufHolder)message).duplicate().retain();
        }
        return ReferenceCountUtil.retain((Object)message);
    }
}

