/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.handler;

import com.zx.sms.connect.manager.EndpointEntity;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageLogHandler
extends ChannelDuplexHandler {
    private final Logger logger;
    private EndpointEntity entity;

    public MessageLogHandler(EndpointEntity entity) {
        this.entity = entity;
        this.logger = entity != null ? LoggerFactory.getLogger((String)String.format("entity.%s", entity.getId())) : LoggerFactory.getLogger(MessageLogHandler.class);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.logger.warn("handlerAdded . {}", (Object)this.entity);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.logger.warn("Connection close . {}", (Object)this.entity);
        ctx.fireChannelInactive();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.logger.debug("Receive:{}", msg);
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        final Object finalmsg = msg;
        ctx.write(msg, promise);
        promise.addListener(new GenericFutureListener(){

            public void operationComplete(Future future) throws Exception {
                if (!future.isSuccess()) {
                    MessageLogHandler.this.logger.error("ErrSend:{}", future.cause());
                } else {
                    MessageLogHandler.this.logger.debug("Send:{}", finalmsg);
                }
            }
        });
    }
}

