/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.mbean;

import com.zx.sms.connect.manager.EndpointConnector;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.EndpointManager;
import com.zx.sms.connect.manager.ServerEndpoint;
import com.zx.sms.mbean.ConnStateMBean;
import com.zx.sms.session.cmpp.SessionStateManager;
import io.netty.channel.Channel;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ConnState
implements ConnStateMBean {
    @Override
    public String print(String entityId) {
        StringBuilder sb = new StringBuilder();
        EndpointManager em = EndpointManager.INS;
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            Set<EndpointEntity> enlist = em.allEndPointEntity();
            for (EndpointEntity e : enlist) {
                sb.append(String.valueOf(e.getId()) + ":\n");
                sb.append(this.printOne(e));
            }
        } else {
            EndpointEntity e = em.getEndpointEntity(entityId);
            if (e != null) {
                sb.append(String.valueOf(e.getId()) + ":\n");
                sb.append(this.printOne(e));
            }
        }
        return sb.toString();
    }

    private String printOne(EndpointEntity e) {
        StringBuilder sb = new StringBuilder();
        EndpointConnector<?> econn = EndpointManager.INS.getEndpointConnector(e);
        if (econn == null) {
            return "";
        }
        Channel[] carr = econn.getallChannel();
        if (carr != null && carr.length > 0) {
            int i = 0;
            while (i < carr.length) {
                Channel ch = carr[i];
                SessionStateManager ssm = (SessionStateManager)ch.pipeline().get("sessionStateManager");
                sb.append("\tch[");
                sb.append(ch.localAddress().toString());
                if (e instanceof ServerEndpoint) {
                    sb.append("<-");
                } else {
                    sb.append("->");
                }
                sb.append(String.valueOf(ch.remoteAddress().toString()) + "]");
                sb.append("\tWaitting-resp=").append(ssm.getWaittingResp());
                sb.append("\tWriteCount=").append(ssm.getWriteCount());
                sb.append("\tReadCount=").append(ssm.getReadCount());
                sb.append("\n");
                ++i;
            }
        }
        return sb.toString();
    }
}

