/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.session;

import com.zx.sms.connect.manager.ClientEndpoint;
import com.zx.sms.connect.manager.EndpointConnector;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.EndpointManager;
import com.zx.sms.session.cmpp.SessionState;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionLoginManager
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSessionLoginManager.class);
    protected EndpointEntity entity;
    protected SessionState state = SessionState.DisConnect;

    public AbstractSessionLoginManager(EndpointEntity entity) {
        this.entity = entity;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.state == SessionState.DisConnect) {
            logger.error("login error entity : " + this.entity.toString(), cause);
            ctx.close();
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.state == SessionState.DisConnect) {
            if (this.entity instanceof ClientEndpoint) {
                this.receiveConnectResponseMessage(ctx, msg);
            } else {
                this.receiveConnectMessage(ctx, msg);
            }
        }
        ctx.fireChannelRead(msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Channel ch = ctx.channel();
        if (this.state == SessionState.Connect) {
            EndpointConnector<?> conn = EndpointManager.INS.getEndpointConnector(this.entity);
            if (conn != null) {
                conn.removeChannel(ch);
            }
            logger.warn("Connection closed . {} , connect count : {}", (Object)this.entity, (Object)(conn == null ? 0 : conn.getConnectionNum()));
        } else {
            logger.warn("session is not created. the entity is {}.channel remote is {}", (Object)this.entity, (Object)ctx.channel().remoteAddress());
        }
        ctx.fireChannelInactive();
    }

    protected abstract void doLogin(Channel var1);

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.state == SessionState.DisConnect && this.entity instanceof ClientEndpoint) {
            this.doLogin(ctx.channel());
        }
        ctx.fireChannelActive();
    }

    protected abstract EndpointEntity queryEndpointEntityByMsg(Object var1);

    protected abstract boolean validAddressHost(EndpointEntity var1, Channel var2);

    protected abstract int validClientMsg(EndpointEntity var1, Object var2);

    protected abstract int validServermsg(Object var1);

    protected abstract void changeProtoVersion(ChannelHandlerContext var1, EndpointEntity var2, Object var3) throws Exception;

    protected abstract void doLoginSuccess(ChannelHandlerContext var1, EndpointEntity var2, Object var3);

    protected abstract void failedLogin(ChannelHandlerContext var1, Object var2, long var3);

    protected void receiveConnectMessage(ChannelHandlerContext ctx, Object message) throws Exception {
        EndpointEntity childentity = this.queryEndpointEntityByMsg(message);
        if (childentity == null) {
            this.failedLogin(ctx, message, 3L);
            return;
        }
        this.changeProtoVersion(ctx, childentity, message);
        if (!this.validAddressHost(childentity, ctx.channel())) {
            this.failedLogin(ctx, message, 2L);
            return;
        }
        int status = this.validClientMsg(childentity, message);
        if (status == 0) {
            this.entity = childentity;
            EndpointManager.INS.openEndpoint(childentity);
            EndpointConnector<?> conn = EndpointManager.INS.getEndpointConnector(childentity);
            if (conn == null) {
                logger.warn("entity may closed. {}", (Object)childentity);
                this.failedLogin(ctx, message, 5L);
                return;
            }
            if (conn.addChannel(ctx.channel())) {
                IdleStateHandler idlehandler = (IdleStateHandler)ctx.pipeline().get("IdleStateHandler");
                ctx.pipeline().replace((ChannelHandler)idlehandler, "IdleStateHandler", (ChannelHandler)new IdleStateHandler(0L, 0L, (long)childentity.getIdleTimeSec(), TimeUnit.SECONDS));
                this.state = SessionState.Connect;
                this.doLoginSuccess(ctx, childentity, message);
                this.notifyChannelConnected(ctx);
                logger.info("{} login success on channel {}", (Object)childentity.getId(), (Object)ctx.channel());
            } else {
                this.failedLogin(ctx, message, 5L);
            }
        } else {
            this.failedLogin(ctx, message, status);
        }
    }

    private void receiveConnectResponseMessage(ChannelHandlerContext ctx, Object message) throws Exception {
        int status = this.validServermsg(message);
        if (status == 0) {
            EndpointConnector<?> conn = EndpointManager.INS.getEndpointConnector(this.entity);
            if (conn == null) {
                logger.warn("entity may closed. {}", (Object)this.entity);
                ctx.close();
                return;
            }
            if (!conn.addChannel(ctx.channel())) {
                ctx.close();
                return;
            }
        } else {
            logger.info("{} login failed (status = {}) on channel {}", new Object[]{this.entity.getId(), status, ctx.channel()});
            ctx.close();
            return;
        }
        this.state = SessionState.Connect;
        this.notifyChannelConnected(ctx);
        logger.info("{} login success on channel {}", (Object)this.entity.getId(), (Object)ctx.channel());
    }

    private void notifyChannelConnected(ChannelHandlerContext ctx) {
        ctx.channel().pipeline().fireUserEventTriggered((Object)SessionState.Connect);
    }
}

