/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.session.cmpp;

import com.zx.sms.codec.cmpp.msg.CmppActiveTestRequestMessage;
import com.zx.sms.codec.cmpp.msg.CmppDeliverResponseMessage;
import com.zx.sms.codec.cmpp.msg.CmppSubmitResponseMessage;
import com.zx.sms.codec.cmpp.msg.Message;
import com.zx.sms.common.storedMap.VersionObject;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.session.AbstractSessionStateManager;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionStateManager
extends AbstractSessionStateManager<Long, Message> {
    private static final Logger logger = LoggerFactory.getLogger(SessionStateManager.class);

    public SessionStateManager(EndpointEntity entity, ConcurrentMap<Long, VersionObject<Message>> storeMap, boolean preSend) {
        super(entity, storeMap, preSend);
    }

    @Override
    protected Long getSequenceId(Message msg) {
        return msg.getHeader().getSequenceId();
    }

    @Override
    protected boolean needSendAgainByResponse(Message req, Message res) {
        if (res instanceof CmppSubmitResponseMessage) {
            CmppSubmitResponseMessage submitResp = (CmppSubmitResponseMessage)res;
            if (submitResp.getResult() != 0L && submitResp.getResult() != 8L) {
                logger.error("Send SubmitMsg ERR . Msg: {} ,Resp:{}", (Object)req, (Object)submitResp);
            }
            return submitResp.getResult() == 8L;
        }
        if (res instanceof CmppDeliverResponseMessage) {
            CmppDeliverResponseMessage deliverResp = (CmppDeliverResponseMessage)res;
            if (deliverResp.getResult() != 0L && deliverResp.getResult() != 8L) {
                logger.error("Send DeliverMsg ERR . Msg: {} ,Resp:{}", (Object)req, (Object)deliverResp);
            }
            return deliverResp.getResult() == 8L;
        }
        return false;
    }

    @Override
    protected boolean closeWhenRetryFailed(Message req) {
        if (req instanceof CmppActiveTestRequestMessage) {
            return true;
        }
        return this.getEntity().isCloseWhenRetryFailed();
    }
}

