/*
 * Decompiled with CFR 0.152.
 */
package com.zx.sms.session.smgp;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.zx.sms.codec.smgp.msg.SMGPLoginMessage;
import com.zx.sms.codec.smgp.msg.SMGPLoginRespMessage;
import com.zx.sms.common.util.CachedMillisecondClock;
import com.zx.sms.connect.manager.EndpointEntity;
import com.zx.sms.connect.manager.smgp.SMGPEndpointEntity;
import com.zx.sms.connect.manager.smgp.SMGPServerChildEndpointEntity;
import com.zx.sms.connect.manager.smgp.SMGPServerEndpointEntity;
import com.zx.sms.session.AbstractSessionLoginManager;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Arrays;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMGPSessionLoginManager
extends AbstractSessionLoginManager {
    private static final Logger logger = LoggerFactory.getLogger(SMGPSessionLoginManager.class);

    public SMGPSessionLoginManager(EndpointEntity entity) {
        super(entity);
    }

    @Override
    protected void doLogin(Channel ch) {
        SMGPEndpointEntity cliententity = (SMGPEndpointEntity)this.entity;
        SMGPLoginMessage req = new SMGPLoginMessage();
        req.setClientId(cliententity.getClientID());
        String timestamp = DateFormatUtils.format((long)CachedMillisecondClock.INS.now(), (String)"MMddHHmmss");
        req.setTimestamp(Long.parseLong(timestamp));
        byte[] userBytes = cliententity.getClientID().getBytes(cliententity.getChartset());
        byte[] passwdBytes = cliententity.getPassword().getBytes(cliententity.getChartset());
        byte[] timestampBytes = timestamp.getBytes(cliententity.getChartset());
        req.setClientAuth(DigestUtils.md5((byte[])Bytes.concat((byte[][])new byte[][]{userBytes, new byte[7], passwdBytes, timestampBytes})));
        req.setVersion(cliententity.getClientVersion());
        byte loginMode = (byte)(cliententity.getChannelType() == EndpointEntity.ChannelType.DUPLEX ? 2 : (cliententity.getChannelType() == EndpointEntity.ChannelType.UP ? 1 : 0));
        req.setLoginMode(loginMode);
        ch.writeAndFlush((Object)req);
        logger.info("session Start :Send SMGPLoginMessage seq :{}", (Object)req.getSequenceNo());
    }

    @Override
    protected EndpointEntity queryEndpointEntityByMsg(Object msg) {
        if (msg instanceof SMGPLoginMessage) {
            SMGPLoginMessage message = (SMGPLoginMessage)msg;
            String username = message.getClientId();
            byte loginMode = message.getLoginMode();
            if (this.entity instanceof SMGPServerEndpointEntity) {
                SMGPServerEndpointEntity serverEntity = (SMGPServerEndpointEntity)this.entity;
                EndpointEntity end = serverEntity.getChild(username.trim());
                if (end == null) {
                    return null;
                }
                if (end.getChannelType() == EndpointEntity.ChannelType.DOWN && loginMode == 0) {
                    return end;
                }
                if (end.getChannelType() == EndpointEntity.ChannelType.UP && loginMode == 1) {
                    return end;
                }
                if (end.getChannelType() == EndpointEntity.ChannelType.DUPLEX && loginMode == 2) {
                    return end;
                }
            }
        }
        return null;
    }

    @Override
    protected boolean validAddressHost(EndpointEntity childentity, Channel channel) {
        return true;
    }

    private int validClientMsg(SMGPLoginMessage message, SMGPServerChildEndpointEntity entity) {
        byte[] userBytes = entity.getClientID().getBytes(entity.getChartset());
        byte[] passwdBytes = entity.getPassword().getBytes(entity.getChartset());
        byte[] timestampBytes = String.format("%010d", message.getTimestamp()).getBytes(entity.getChartset());
        byte[] authBytes = DigestUtils.md5((byte[])Bytes.concat((byte[][])new byte[][]{userBytes, new byte[7], passwdBytes, timestampBytes}));
        System.out.println(message);
        if (Arrays.equals(authBytes, message.getClientAuth())) {
            return 0;
        }
        logger.error("AuthenticatorSource valided failed");
        return 3;
    }

    @Override
    protected int validClientMsg(EndpointEntity entity, Object msg) {
        SMGPServerChildEndpointEntity smgpentity = (SMGPServerChildEndpointEntity)entity;
        SMGPLoginMessage message = (SMGPLoginMessage)msg;
        return this.validClientMsg(message, smgpentity);
    }

    @Override
    protected int validServermsg(Object message) {
        if (message instanceof SMGPLoginRespMessage) {
            SMGPLoginRespMessage resp = (SMGPLoginRespMessage)message;
            return resp.getStatus();
        }
        logger.error("connect msg type error : {}", message);
        return 9;
    }

    @Override
    protected void changeProtoVersion(ChannelHandlerContext ctx, EndpointEntity entity, Object message) throws Exception {
    }

    @Override
    protected void doLoginSuccess(ChannelHandlerContext ctx, EndpointEntity entity, Object message) {
        SMGPServerChildEndpointEntity smgpentity = (SMGPServerChildEndpointEntity)entity;
        SMGPLoginMessage req = (SMGPLoginMessage)message;
        SMGPLoginRespMessage resp = new SMGPLoginRespMessage();
        resp.setSequenceNumber(req.getSequenceNo());
        resp.setStatus(0);
        resp.setVersion(smgpentity.getClientVersion());
        resp.setServerAuth(DigestUtils.md5((byte[])Bytes.concat((byte[][])new byte[][]{Ints.toByteArray((int)resp.getStatus()), req.getClientAuth(), smgpentity.getPassword().getBytes(smgpentity.getChartset())})));
        ctx.channel().writeAndFlush((Object)resp);
    }

    @Override
    protected void failedLogin(ChannelHandlerContext ctx, Object msg, long status) {
        if (msg instanceof SMGPLoginMessage) {
            logger.error("Connected error status :{}", (Object)status);
            SMGPLoginMessage message = (SMGPLoginMessage)msg;
            SMGPLoginRespMessage resp = new SMGPLoginRespMessage();
            resp.setSequenceNumber(message.getSequenceNo());
            resp.setStatus((int)status);
            ChannelFuture promise = ctx.writeAndFlush((Object)resp);
            final ChannelHandlerContext finalctx = ctx;
            promise.addListener(new GenericFutureListener(){

                public void operationComplete(Future future) throws Exception {
                    finalctx.close();
                }
            });
        } else {
            logger.error("connect msg type error : {}", msg);
            ctx.close();
        }
    }
}

