/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.definition;

import es.rickyepoderi.wbxml.definition.WbXmlAttributeDef;
import es.rickyepoderi.wbxml.definition.WbXmlAttributeValueDef;
import es.rickyepoderi.wbxml.definition.WbXmlDefinition;
import es.rickyepoderi.wbxml.definition.WbXmlExtensionDef;
import es.rickyepoderi.wbxml.definition.WbXmlNamespaceDef;
import es.rickyepoderi.wbxml.definition.WbXmlTagDef;
import es.rickyepoderi.wbxml.document.OpaqueAttributePlugin;
import es.rickyepoderi.wbxml.document.OpaqueContentPlugin;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;

public class WbXmlInitialization {
    protected static final Logger log = Logger.getLogger(WbXmlInitialization.class.getName());
    public static final String RESOURCE_DIRECTORY_PROPERTY = "es.rickyepoderi.wbxml.definition.path";
    public static final String DEFAULT_RESOURCE_DIRECTORY = "es/rickyepoderi/wbxml/definition/defaults";
    public static final String PROPERTIES_SUFFIX = ".properties";
    public static final String PROPERTIES_PREFIX = "wbxml.";
    public static final String PROP_WBXML_NAME = "wbxml.name";
    public static final String PROP_WBXML_PUBLIC_ID = "wbxml.publicid";
    public static final String PROP_WBXML_XML_PUBLIC_IDENTIFIER = "wbxml.xmlpublicidentifier";
    public static final String PROP_WBXML_XML_URI_REFERENCE = "wbxml.xmlurireference";
    public static final String PROP_WBXML_ROOT_ELEMENT = "wbxml.rootelement";
    public static final String PROP_WBXML_CLASS_ELEMENT = "wbxml.class";
    public static final String PROP_WBXML_TAG_PREFIX = "wbxml.tag.";
    public static final String PROP_WBXML_NAMESPACE_PREFIX = "wbxml.namespaces.";
    public static final String PROP_WBXML_ATTR_PREFIX = "wbxml.attr.";
    public static final String PROP_WBXML_ATTR_VALUE_PREFIX = "wbxml.attrvalue.";
    public static final String PROP_WBXML_EXT_PREFIX = "wbxml.ext.";
    public static final String PROP_WBXML_OPAQUE_ATTR_PREFIX = "wbxml.opaque.attr.";
    public static final String PROP_WBXML_OPAQUE_TAG_PREFIX = "wbxml.opaque.tag.";
    public static final String PROP_WBXML_VALUE_SUFFIX = ".value";
    public static final String PROP_WBXML_LINKED_DEF = "wbxml.opaque.linkeddef.";
    private static List<WbXmlDefinition> definitions = null;

    static {
        definitions = new ArrayList<WbXmlDefinition>();
        WbXmlInitialization.init();
    }

    private static WbXmlTagDef getTagDefinition(String key, String value) {
        try {
            String[] keys = key.split(Pattern.quote("."));
            byte pageCode = Integer.decode(keys[2]).byteValue();
            String name = keys[3];
            String prefix = null;
            int idx = name.indexOf(58);
            if (idx > 0) {
                prefix = name.substring(0, idx);
                name = name.substring(idx + 1);
            }
            byte token = Integer.decode(value).byteValue();
            return new WbXmlTagDef(prefix, name, token, pageCode);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error loading attribute {0}={1}", new Object[]{key, value});
            log.log(Level.SEVERE, "Exception", e);
            return null;
        }
    }

    private static WbXmlNamespaceDef getNamespaceDefinition(String key, String value) {
        try {
            String[] keys = key.split(Pattern.quote("."));
            String prefix = keys[2];
            String namespace = value;
            return new WbXmlNamespaceDef(prefix, namespace);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error loading attribute {0}={1}", new Object[]{key, value});
            log.log(Level.SEVERE, "Exception", e);
            return null;
        }
    }

    private static WbXmlAttributeDef getAttrDefinition(Properties props, String key, String value) {
        try {
            String val = props.getProperty(String.valueOf(key) + PROP_WBXML_VALUE_SUFFIX);
            String[] keys = key.split(Pattern.quote("."));
            byte pageCode = Integer.decode(keys[2]).byteValue();
            String name = keys[3];
            String prefix = null;
            int idx = name.indexOf(58);
            if (idx > 0) {
                prefix = name.substring(0, idx);
                name = name.substring(idx + 1);
            }
            byte token = Integer.decode(value).byteValue();
            return new WbXmlAttributeDef(prefix, name, token, pageCode, val);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error loading attribute {0}={1}", new Object[]{key, value});
            log.log(Level.SEVERE, "Exception", e);
            return null;
        }
    }

    private static WbXmlAttributeValueDef getAttrValueDefinition(Properties props, String key, String value) {
        try {
            String[] keys = key.split(Pattern.quote("."));
            byte pageCode = Integer.decode(keys[2]).byteValue();
            byte token = Integer.decode(value).byteValue();
            String val = props.getProperty(String.valueOf(key) + PROP_WBXML_VALUE_SUFFIX);
            return new WbXmlAttributeValueDef(val, token, pageCode);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error loading attribute value {0}={1}", new Object[]{key, value});
            log.log(Level.SEVERE, "Exception", e);
            return null;
        }
    }

    private static WbXmlExtensionDef getExtDefinition(Properties props, String key, String value) {
        try {
            byte token = Integer.decode(value).byteValue();
            String val = props.getProperty(String.valueOf(key) + PROP_WBXML_VALUE_SUFFIX);
            return new WbXmlExtensionDef(val, token);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error loading extension {0}={1}", new Object[]{key, value});
            log.log(Level.SEVERE, "Exception", e);
            return null;
        }
    }

    private static void addOpaqueAttrPlugin(WbXmlDefinition def, Properties props, String key, String value) {
        try {
            String[] keys = key.split(Pattern.quote("."));
            byte pageCode = Integer.decode(keys[3]).byteValue();
            String name = keys[4];
            String tagProp = PROP_WBXML_ATTR_PREFIX + pageCode + "." + name;
            WbXmlAttributeDef attrDef = WbXmlInitialization.getAttrDefinition(props, tagProp, props.getProperty(tagProp));
            Class<?> clazz = Class.forName(value);
            OpaqueAttributePlugin plugin = (OpaqueAttributePlugin)clazz.newInstance();
            def.addOpaqueAttr(attrDef, plugin);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error loading plugin {0}={1}", new Object[]{key, value});
            log.log(Level.SEVERE, "Exception", e);
        }
    }

    private static void addOpaqueTagPlugin(WbXmlDefinition def, Properties props, String key, String value) {
        try {
            String[] keys = key.split(Pattern.quote("."));
            byte pageCode = Integer.decode(keys[3]).byteValue();
            String name = keys[4];
            String tagProp = PROP_WBXML_TAG_PREFIX + pageCode + "." + name;
            WbXmlTagDef tagDef = WbXmlInitialization.getTagDefinition(tagProp, props.getProperty(tagProp));
            Class<?> clazz = Class.forName(value);
            OpaqueContentPlugin plugin = (OpaqueContentPlugin)clazz.newInstance();
            def.addOpaqueTag(tagDef, plugin);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error loading plugin {0}={1}", new Object[]{key, value});
            log.log(Level.SEVERE, "Exception", e);
        }
    }

    private static void addLinkedDefinition(WbXmlDefinition def, String value) {
        def.getLinkedDefinitions().put(value, null);
    }

    private static WbXmlDefinition loadDefinition(Properties props) {
        String name = props.getProperty(PROP_WBXML_NAME);
        long publicId = Long.decode(props.getProperty(PROP_WBXML_PUBLIC_ID));
        String xmlPublicId = props.getProperty(PROP_WBXML_XML_PUBLIC_IDENTIFIER);
        String xmlUriRef = props.getProperty(PROP_WBXML_XML_URI_REFERENCE);
        String clazz = props.getProperty(PROP_WBXML_CLASS_ELEMENT);
        WbXmlDefinition def = new WbXmlDefinition(name, publicId, xmlPublicId, xmlUriRef, clazz);
        for (String key : props.stringPropertyNames()) {
            if (key.startsWith(PROP_WBXML_TAG_PREFIX)) {
                WbXmlTagDef tag = WbXmlInitialization.getTagDefinition(key, props.getProperty(key));
                if (tag == null) continue;
                def.addTag(tag);
                continue;
            }
            if (key.startsWith(PROP_WBXML_NAMESPACE_PREFIX)) {
                WbXmlNamespaceDef ns = WbXmlInitialization.getNamespaceDefinition(key, props.getProperty(key));
                if (ns == null) continue;
                def.addNamespace(ns);
                continue;
            }
            if (key.startsWith(PROP_WBXML_ATTR_PREFIX) && !key.endsWith(PROP_WBXML_VALUE_SUFFIX)) {
                WbXmlAttributeDef attr = WbXmlInitialization.getAttrDefinition(props, key, props.getProperty(key));
                if (attr == null) continue;
                def.addAttr(attr);
                continue;
            }
            if (key.startsWith(PROP_WBXML_ATTR_VALUE_PREFIX) && !key.endsWith(PROP_WBXML_VALUE_SUFFIX)) {
                WbXmlAttributeValueDef attrVal = WbXmlInitialization.getAttrValueDefinition(props, key, props.getProperty(key));
                if (attrVal == null) continue;
                def.addAttrValue(attrVal);
                continue;
            }
            if (key.startsWith(PROP_WBXML_EXT_PREFIX) && !key.endsWith(PROP_WBXML_VALUE_SUFFIX)) {
                WbXmlExtensionDef ext = WbXmlInitialization.getExtDefinition(props, key, props.getProperty(key));
                if (ext == null) continue;
                def.addExtension(ext);
                continue;
            }
            if (key.startsWith(PROP_WBXML_OPAQUE_ATTR_PREFIX)) {
                WbXmlInitialization.addOpaqueAttrPlugin(def, props, key, props.getProperty(key));
                continue;
            }
            if (key.startsWith(PROP_WBXML_OPAQUE_TAG_PREFIX)) {
                WbXmlInitialization.addOpaqueTagPlugin(def, props, key, props.getProperty(key));
                continue;
            }
            if (!key.startsWith(PROP_WBXML_LINKED_DEF)) continue;
            WbXmlInitialization.addLinkedDefinition(def, props.getProperty(key));
        }
        String root = props.getProperty(PROP_WBXML_ROOT_ELEMENT);
        def.setRoot(root);
        return def;
    }

    private static void loadPropertiesJar(URL resource, String path) {
        ZipFile jar = null;
        try {
            try {
                JarURLConnection jarConn = (JarURLConnection)resource.openConnection();
                jar = jarConn.getJarFile();
                Enumeration<JarEntry> e = ((JarFile)jar).entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    if (!entry.getName().startsWith(String.valueOf(path) + "/" + PROPERTIES_PREFIX) || !entry.getName().endsWith(PROPERTIES_SUFFIX)) continue;
                    Properties props = new Properties();
                    props.load(((JarFile)jar).getInputStream(entry));
                    definitions.add(WbXmlInitialization.loadDefinition(props));
                }
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "loadPropertiesJar(): Error loading definition {0}", resource);
                log.log(Level.SEVERE, "loadPropertiesJar(): Error loading definition...", e);
                try {
                    if (jar != null) {
                        jar.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void loadPropertiesFile(File file) {
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                block17: {
                    File f = fileArray[n2];
                    if (f.isFile() && f.getName().endsWith(PROPERTIES_SUFFIX) && f.getName().startsWith(PROPERTIES_PREFIX)) {
                        InputStreamReader reader = null;
                        try {
                            try {
                                Properties props = new Properties();
                                reader = new FileReader(f);
                                props.load(reader);
                                definitions.add(WbXmlInitialization.loadDefinition(props));
                            }
                            catch (IOException e) {
                                log.log(Level.SEVERE, "loadPropertiesFile(): Error loading definition {0}", file.getAbsoluteFile());
                                log.log(Level.SEVERE, "loadPropertiesFile(): Error loading definition...", e);
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private static void processLinkedDefinitions() {
        WbXmlDefinition[] wbXmlDefinitionArray = WbXmlInitialization.getDefinitions();
        int n = wbXmlDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            WbXmlDefinition def = wbXmlDefinitionArray[n2];
            if (!def.getLinkedDefinitions().isEmpty()) {
                for (String name : def.getLinkedDefinitions().keySet()) {
                    WbXmlDefinition linkedDef = WbXmlInitialization.getDefinitionByName(name);
                    if (linkedDef != null) {
                        def.getLinkedDefinitions().put(name, linkedDef);
                        continue;
                    }
                    def.getLinkedDefinitions().remove(name);
                    log.log(Level.WARNING, "The linked definition {0} defined in {1} does not exists", new Object[]{name, def.getName()});
                }
            }
            ++n2;
        }
    }

    private static void init() {
        URL resource;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String resourcePath = System.getProperty(RESOURCE_DIRECTORY_PROPERTY);
        if (resourcePath == null) {
            resourcePath = DEFAULT_RESOURCE_DIRECTORY;
        }
        if ((resource = classLoader.getResource(resourcePath)) == null) {
            log.log(Level.SEVERE, "The definition path {0} is not found inside the classpath", resource);
            throw new IllegalStateException(String.format("The definition path '%s' is not found inside the classpath", resourcePath));
        }
        if (resource.getProtocol().equals("jar")) {
            WbXmlInitialization.loadPropertiesJar(resource, DEFAULT_RESOURCE_DIRECTORY);
            WbXmlInitialization.processLinkedDefinitions();
        } else if (resource.getProtocol().equals("file")) {
            WbXmlInitialization.loadPropertiesFile(new File(resource.getFile()));
            WbXmlInitialization.processLinkedDefinitions();
        } else {
            log.log(Level.SEVERE, "Invalid protocol for the definitions directory: {0}", resource);
            throw new IllegalStateException(String.format("Invalid protocol for the definitions directory '%s'", resource.getProtocol()));
        }
    }

    public static synchronized WbXmlDefinition[] getDefinitions() {
        return definitions.toArray(new WbXmlDefinition[0]);
    }

    public static synchronized WbXmlDefinition getDefinitionByFPI(String fpi) {
        for (WbXmlDefinition def : definitions) {
            if (def.getXmlPublicId() == null || !def.getXmlPublicId().equals(fpi)) continue;
            return def;
        }
        return null;
    }

    public static synchronized WbXmlDefinition getDefinitionByPublicId(long id) {
        for (WbXmlDefinition def : definitions) {
            if (def.getPublicId() != id) continue;
            return def;
        }
        return null;
    }

    public static synchronized WbXmlDefinition getDefinitionByName(String name) {
        for (WbXmlDefinition def : definitions) {
            if (def.getName() == null || !def.getName().equals(name)) continue;
            return def;
        }
        return null;
    }

    public static synchronized WbXmlDefinition getDefinitionByRoot(String root, String namespaceUri) {
        for (WbXmlDefinition def : definitions) {
            String prefix;
            if (namespaceUri != null && !namespaceUri.isEmpty() && (prefix = def.getPrefix(namespaceUri)) != null) {
                root = prefix + ":" + root;
            }
            if (def.getRoot() == null || !def.getRoot().getNameWithPrefix().equals(root)) continue;
            return def;
        }
        return null;
    }

    public static synchronized void reload() {
        definitions.clear();
        WbXmlInitialization.init();
    }
}

