/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.document;

import es.rickyepoderi.wbxml.document.WbXmlAttribute;
import es.rickyepoderi.wbxml.document.WbXmlContent;
import es.rickyepoderi.wbxml.document.WbXmlEncoder;
import es.rickyepoderi.wbxml.document.WbXmlLiterals;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class WbXmlElement {
    protected static final Logger log = Logger.getLogger(WbXmlElement.class.getName());
    private String tag = null;
    private List<WbXmlAttribute> attributes = null;
    private List<WbXmlContent> contents = null;
    private boolean compacted = false;

    protected WbXmlElement() {
        this((String)null, (WbXmlAttribute[])null, (WbXmlContent[])null);
    }

    public WbXmlElement(String tag) {
        this(tag, (WbXmlAttribute[])null, (WbXmlContent[])null);
    }

    public WbXmlElement(String tag, WbXmlAttribute attribute, WbXmlContent content) {
        this(tag, new WbXmlAttribute[]{attribute}, new WbXmlContent[]{content});
    }

    public WbXmlElement(String tag, WbXmlAttribute attribute, WbXmlElement element) {
        this(tag, new WbXmlAttribute[]{attribute}, new WbXmlContent[]{new WbXmlContent(element)});
    }

    public WbXmlElement(String tag, WbXmlAttribute attribute, String string) {
        this(tag, new WbXmlAttribute[]{attribute}, new WbXmlContent[]{new WbXmlContent(string)});
    }

    public WbXmlElement(String tag, WbXmlAttribute attribute) {
        this(tag, new WbXmlAttribute[]{attribute}, (WbXmlContent[])null);
    }

    public WbXmlElement(String tag, WbXmlAttribute[] attributes) {
        this(tag, attributes, (WbXmlContent[])null);
    }

    public WbXmlElement(String tag, WbXmlAttribute[] attributes, WbXmlContent content) {
        this(tag, attributes, new WbXmlContent[]{content});
    }

    public WbXmlElement(String tag, WbXmlAttribute[] attributes, WbXmlElement element) {
        this(tag, attributes, new WbXmlContent[]{new WbXmlContent(element)});
    }

    public WbXmlElement(String tag, WbXmlAttribute[] attributes, String string) {
        this(tag, attributes, new WbXmlContent[]{new WbXmlContent(string)});
    }

    public WbXmlElement(String tag, WbXmlContent content) {
        this(tag, (WbXmlAttribute[])null, new WbXmlContent[]{content});
    }

    public WbXmlElement(String tag, WbXmlElement element) {
        this(tag, (WbXmlAttribute[])null, new WbXmlContent[]{new WbXmlContent(element)});
    }

    public WbXmlElement(String tag, String string) {
        this(tag, (WbXmlAttribute[])null, new WbXmlContent[]{new WbXmlContent(string)});
    }

    public WbXmlElement(String tag, WbXmlAttribute attribute, WbXmlContent[] contents) {
        this(tag, new WbXmlAttribute[]{attribute}, contents);
    }

    private static WbXmlContent[] createContentsArrayFromElement(WbXmlElement[] elements) {
        if (elements == null) {
            return null;
        }
        WbXmlContent[] contents = new WbXmlContent[elements.length];
        int i = 0;
        while (i < elements.length) {
            contents[i] = new WbXmlContent(elements[i]);
            ++i;
        }
        return contents;
    }

    public WbXmlElement(String tag, WbXmlAttribute attribute, WbXmlElement[] elements) {
        this(tag, new WbXmlAttribute[]{attribute}, WbXmlElement.createContentsArrayFromElement(elements));
    }

    private static WbXmlContent[] createContentsArrayFromString(String[] strings) {
        if (strings == null) {
            return null;
        }
        WbXmlContent[] contents = new WbXmlContent[strings.length];
        int i = 0;
        while (i < strings.length) {
            contents[i] = new WbXmlContent(strings[i]);
            ++i;
        }
        return contents;
    }

    public WbXmlElement(String tag, WbXmlAttribute attribute, String[] strings) {
        this(tag, new WbXmlAttribute[]{attribute}, WbXmlElement.createContentsArrayFromString(strings));
    }

    public WbXmlElement(String tag, WbXmlContent[] contents) {
        this(tag, (WbXmlAttribute[])null, contents);
    }

    public WbXmlElement(String tag, WbXmlElement[] elements) {
        this(tag, (WbXmlAttribute[])null, WbXmlElement.createContentsArrayFromElement(elements));
    }

    public WbXmlElement(String tag, String[] strings) {
        this(tag, (WbXmlAttribute[])null, WbXmlElement.createContentsArrayFromString(strings));
    }

    public WbXmlElement(String tag, WbXmlAttribute[] attributes, WbXmlContent[] contents) {
        this.tag = tag;
        this.attributes = new ArrayList<WbXmlAttribute>();
        if (attributes != null) {
            this.attributes.addAll(Arrays.asList(attributes));
        }
        this.contents = new ArrayList<WbXmlContent>();
        if (contents != null) {
            this.contents.addAll(Arrays.asList(contents));
        }
    }

    public boolean isCompacted() {
        return this.compacted;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean isPrefixed() {
        return this.tag.indexOf(58) >= 0;
    }

    public String getTagPrefix() {
        int idx = this.tag.indexOf(58);
        if (idx >= 0) {
            return this.tag.substring(0, idx);
        }
        return null;
    }

    public String getTagWithoutPrefix() {
        int idx = this.tag.indexOf(58);
        if (idx >= 0) {
            return this.tag.substring(idx + 1);
        }
        return this.tag;
    }

    public WbXmlElement setTag(String tag) {
        this.tag = tag;
        return this;
    }

    public WbXmlElement addAttribute(WbXmlAttribute attribute) {
        this.attributes.add(attribute);
        return this;
    }

    public boolean isAttributesEmpty() {
        return this.attributes.isEmpty();
    }

    public int attributesSize() {
        return this.attributes.size();
    }

    public WbXmlAttribute getAttribute(int idx) {
        return this.attributes.get(idx);
    }

    public WbXmlAttribute getAttribute(String name) {
        for (WbXmlAttribute attr : this.attributes) {
            if (!name.equals(attr.getName())) continue;
            return attr;
        }
        return null;
    }

    public List<WbXmlAttribute> getAttributes() {
        return this.attributes;
    }

    public WbXmlElement addContent(WbXmlContent content) {
        this.contents.add(content);
        return this;
    }

    public boolean isContentsEmpty() {
        return this.contents.isEmpty();
    }

    public int contentsSize() {
        return this.contents.size();
    }

    public WbXmlContent getContent(int idx) {
        return this.contents.get(idx);
    }

    public List<WbXmlContent> getContents() {
        return this.contents;
    }

    public void compact(WbXmlEncoder encoder) {
        ArrayList<WbXmlContent> newContents = new ArrayList<WbXmlContent>();
        for (WbXmlContent content : this.contents) {
            if (content.isString() && encoder.getDefinition().locateTagPlugin(this.tag) == null) {
                List<String> strings = encoder.getDefinition().compactExtension(content.getString());
                for (String string : strings) {
                    newContents.add(new WbXmlContent(string));
                }
                continue;
            }
            newContents.add(content);
        }
        this.contents = newContents;
        this.compacted = true;
    }

    public void normalize() {
        ArrayList<WbXmlContent> newContents = new ArrayList<WbXmlContent>();
        StringBuilder sb = new StringBuilder();
        for (WbXmlContent content : this.contents) {
            if (content.isString() && !content.isEntity()) {
                sb.append(content.getString());
                continue;
            }
            if (sb.length() > 0) {
                newContents.add(new WbXmlContent(sb.toString()));
                sb.setLength(0);
            }
            newContents.add(content);
        }
        if (sb.length() > 0) {
            newContents.add(new WbXmlContent(sb.toString()));
        }
        this.contents = newContents;
        this.compacted = false;
    }

    public String toString(int ident) {
        String spaces = WbXmlLiterals.identString(ident);
        StringBuilder sb = new StringBuilder(spaces);
        sb.append(this.getClass().getSimpleName());
        sb.append(": ");
        sb.append("tag=");
        sb.append(this.tag);
        ++ident;
        sb.append(System.getProperty("line.separator"));
        for (WbXmlAttribute a : this.attributes) {
            sb.append(a.toString(ident));
            sb.append(System.getProperty("line.separator"));
        }
        for (WbXmlContent c : this.contents) {
            sb.append(c.toString(ident));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(0);
    }
}

