/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.document.opaque;

import es.rickyepoderi.wbxml.document.OpaqueAttributePlugin;
import es.rickyepoderi.wbxml.document.WbXmlAttribute;
import es.rickyepoderi.wbxml.document.WbXmlElement;
import es.rickyepoderi.wbxml.document.WbXmlEncoder;
import es.rickyepoderi.wbxml.document.WbXmlParser;
import java.io.IOException;
import java.util.Arrays;

public class SiDateTimeOpaque
implements OpaqueAttributePlugin {
    public static byte[] charArrayToHexArray(char[] array) {
        byte[] ascii = new byte[array.length % 2 == 0 ? array.length : array.length + 1];
        int i = 0;
        while (i < ascii.length) {
            ascii[i] = i < ascii.length ? ('A' <= array[i] && array[i] <= 'F' ? (byte)(array[i] - 65) : ('a' <= array[i] && array[i] <= 'f' ? (byte)(array[i] - 97) : ('0' <= array[i] && array[i] <= '9' ? (byte)(array[i] - 48) : (byte)0))) : (byte)0;
            ++i;
        }
        byte[] result = new byte[array.length / 2];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (byte)(ascii[i2 * 2] * 16 | ascii[i2 * 2 + 1]);
            ++i2;
        }
        i2 = result.length - 1;
        while (i2 >= 0 && result[i2] == 0) {
            --i2;
        }
        if (i2 < result.length - 1) {
            result = Arrays.copyOf(result, i2 + 1);
        }
        return result;
    }

    public static char[] hexArrayToCharArray(byte[] array) {
        char[] buffer = new char[array.length * 2];
        int i = array.length - 1;
        while (i >= 0) {
            char c;
            byte b = (byte)((array[i] & 0xF) % 16);
            buffer[i * 2 + 1] = c = b < 10 ? (char)(48 + b) : (char)(65 + b - 10);
            b = (byte)(((array[i] & 0xF0) >> 4) % 16);
            buffer[i * 2] = c = b < 10 ? (char)(48 + b) : (char)(65 + b - 10);
            --i;
        }
        return buffer;
    }

    @Override
    public void encode(WbXmlEncoder encoder, WbXmlElement element, WbXmlAttribute attr, String value) throws IOException {
        if (value == null || value.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (!Character.isDigit(ch)) {
                if (ch != 'T' && ch != 'Z' && ch != '-' && ch != ':') {
                    throw new IOException(String.format("Invalid date format '%s'!", value));
                }
            } else {
                sb.append(ch);
            }
            ++i;
        }
        byte[] bytes = SiDateTimeOpaque.charArrayToHexArray(sb.toString().toCharArray());
        encoder.writeOpaque(bytes);
    }

    @Override
    public String parse(WbXmlParser parser, byte[] data) throws IOException {
        if (data == null) {
            return null;
        }
        String value = new String(SiDateTimeOpaque.hexArrayToCharArray(data));
        String year = "0000";
        if (value.length() >= 4) {
            year = value.substring(0, 4);
        }
        String month = "00";
        if (value.length() >= 6) {
            month = value.substring(4, 6);
        }
        String day = "00";
        if (value.length() >= 8) {
            day = value.substring(6, 8);
        }
        String hour = "00";
        if (value.length() >= 10) {
            hour = value.substring(8, 10);
        }
        String minute = "00";
        if (value.length() >= 12) {
            minute = value.substring(10, 12);
        }
        String second = "00";
        if (value.length() >= 14) {
            second = value.substring(12, 14);
        }
        return year + "-" + month + "-" + day + "T" + hour + ":" + minute + ":" + second + "Z";
    }
}

