/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.document.opaque;

import es.rickyepoderi.wbxml.definition.WbXmlDefinition;
import es.rickyepoderi.wbxml.document.OpaqueContentPlugin;
import es.rickyepoderi.wbxml.document.WbXmlBody;
import es.rickyepoderi.wbxml.document.WbXmlContent;
import es.rickyepoderi.wbxml.document.WbXmlDocument;
import es.rickyepoderi.wbxml.document.WbXmlElement;
import es.rickyepoderi.wbxml.document.WbXmlEncoder;
import es.rickyepoderi.wbxml.document.WbXmlParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class SyncMLDataOpaque
implements OpaqueContentPlugin {
    @Override
    public void encode(WbXmlEncoder encoder, WbXmlElement element, WbXmlContent content) throws IOException {
        if (content.isString()) {
            encoder.writeString(content.getString());
        } else if (content.isElement()) {
            ByteArrayOutputStream bos = null;
            try {
                if (encoder.getDefinition().locateTag(content.getElement().getTag()) != null) {
                    encoder.encode(content);
                }
                WbXmlDefinition def = encoder.getDefinition().locateLinkedDefinitionForTag(content.getElement().getTag());
                if (def == null) {
                    throw new IOException(String.format("The definition for tag %s is not defined as linked!", content.getElement().getTag()));
                }
                WbXmlDocument doc = new WbXmlDocument(def, encoder.getIanaCharset());
                doc.setBody(new WbXmlBody(content.getElement()));
                bos = new ByteArrayOutputStream();
                WbXmlEncoder tmp = new WbXmlEncoder(bos, doc, encoder.getType());
                tmp.encode();
                bos.flush();
                byte[] bytes = bos.toByteArray();
                encoder.writeOpaque(bytes);
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            throw new IOException("The Data should be a String or a Element");
        }
    }

    @Override
    public WbXmlContent parse(WbXmlParser parser, byte[] data) throws IOException {
        WbXmlContent res;
        WbXmlDocument doc = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            WbXmlParser tmp = new WbXmlParser(bis);
            doc = tmp.parse();
            res = new WbXmlContent(doc.getBody().getElement());
        }
        catch (Exception e) {
            res = new WbXmlContent(new String(data, parser.getCharset()));
        }
        if (res.isElement() && doc != null && parser.getDefinition().getLinkedDef(doc.getDefinition().getName()) == null) {
            throw new IOException(String.format("The definition %s is not defined as linked!", doc.getDefinition().getName()));
        }
        return res;
    }
}

