/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.document.opaque;

import es.rickyepoderi.wbxml.document.OpaqueContentPlugin;
import es.rickyepoderi.wbxml.document.WbXmlContent;
import es.rickyepoderi.wbxml.document.WbXmlElement;
import es.rickyepoderi.wbxml.document.WbXmlEncoder;
import es.rickyepoderi.wbxml.document.WbXmlParser;
import java.io.IOException;

public class WVDateTimeOpaque
implements OpaqueContentPlugin {
    private String parseBytes(byte[] data) {
        int year = ((data[0] & 0x3F) << 6) + (data[1] >> 2 & 0x3F);
        int month = (data[1] & 3) << 2 | data[2] >> 6 & 3;
        int day = data[2] >> 1 & 0x1F;
        int hour = (data[2] & 1) << 4 | data[3] >> 4 & 0xF;
        int min = (data[3] & 0xF) << 2 | data[4] >> 6 & 3;
        int sec = data[4] & 0x3F;
        String timezone = "";
        char c = (char)data[5];
        if (Character.isUpperCase(c)) {
            timezone = new StringBuilder(c).toString();
        }
        String res = String.format("%04d%02d%02dT%02d%02d%02d%s", year, month, day, hour, min, sec, timezone);
        return res;
    }

    @Override
    public void encode(WbXmlEncoder encoderType, WbXmlElement element, WbXmlContent content) throws IOException {
        if (!content.isString()) {
            throw new IOException("The content is not a String!");
        }
        encoderType.encode(content);
    }

    @Override
    public WbXmlContent parse(WbXmlParser parser, byte[] data) throws IOException {
        if (data.length != 6) {
            throw new IOException("A WV opaque DateTime is always 6 byte in length!");
        }
        return new WbXmlContent(this.parseBytes(data));
    }
}

