/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.document.opaque;

import es.rickyepoderi.wbxml.document.OpaqueContentPlugin;
import es.rickyepoderi.wbxml.document.WbXmlContent;
import es.rickyepoderi.wbxml.document.WbXmlElement;
import es.rickyepoderi.wbxml.document.WbXmlEncoder;
import es.rickyepoderi.wbxml.document.WbXmlParser;
import java.io.IOException;
import java.util.Arrays;

public class WVIntegerOpaque
implements OpaqueContentPlugin {
    @Override
    public void encode(WbXmlEncoder encoder, WbXmlElement element, WbXmlContent content) throws IOException {
        if (!content.isString()) {
            throw new IOException("The content is not a String value!");
        }
        long v = Long.decode(content.getString());
        byte[] bytes = new byte[4];
        int i = 3;
        while (i >= 0 && v > 0L) {
            bytes[i] = (byte)(v & 0xFFL);
            v >>= 8;
            --i;
        }
        int start = i + 1;
        encoder.writeOpaque(Arrays.copyOfRange(bytes, start, bytes.length));
    }

    @Override
    public WbXmlContent parse(WbXmlParser parser, byte[] data) throws IOException {
        long v = 0L;
        int i = 0;
        while (i < data.length) {
            v = v << 8 | (long)(data[i] & 0xFF);
            ++i;
        }
        return new WbXmlContent(Long.toString(v));
    }
}

