/*
 * Decompiled with CFR 0.152.
 */
package es.rickyepoderi.wbxml.stream;

import es.rickyepoderi.wbxml.definition.IanaCharset;
import es.rickyepoderi.wbxml.definition.WbXmlDefinition;
import es.rickyepoderi.wbxml.definition.WbXmlInitialization;
import es.rickyepoderi.wbxml.document.WbXmlAttribute;
import es.rickyepoderi.wbxml.document.WbXmlBody;
import es.rickyepoderi.wbxml.document.WbXmlContent;
import es.rickyepoderi.wbxml.document.WbXmlDocument;
import es.rickyepoderi.wbxml.document.WbXmlElement;
import es.rickyepoderi.wbxml.document.WbXmlEncoder;
import es.rickyepoderi.wbxml.document.WbXmlVersion;
import es.rickyepoderi.wbxml.stream.WbXmlNamespaceContext;
import es.rickyepoderi.wbxml.stream.XMLChar;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class WbXmlStreamWriter
implements XMLStreamWriter {
    private static final Logger log = Logger.getLogger(WbXmlStreamWriter.class.getName());
    private OutputStream stream;
    private NamespaceContext userctx;
    private WbXmlDocument doc;
    private Deque<ElementContext> parents;
    private ElementContext current;
    private boolean encoded;
    private WbXmlDefinition def;
    private WbXmlEncoder.StrtblType encoderType;
    private boolean skipSpaces = true;
    private String encoding = null;

    public WbXmlStreamWriter(OutputStream os, WbXmlDefinition def, WbXmlEncoder.StrtblType encoderType, boolean skipSpaces, String encoding) {
        this.stream = os;
        this.current = new ElementContext();
        this.current.setContext(new WbXmlNamespaceContext());
        this.userctx = null;
        this.doc = null;
        this.parents = new ArrayDeque<ElementContext>();
        this.encoded = false;
        this.def = def;
        this.encoderType = encoderType;
        this.skipSpaces = skipSpaces;
        this.encoding = encoding;
    }

    public WbXmlStreamWriter(OutputStream os, WbXmlDefinition def, WbXmlEncoder.StrtblType encoderType, boolean skipSpaces) {
        this(os, def, encoderType, skipSpaces, "UTF-8");
    }

    public WbXmlStreamWriter(OutputStream os, WbXmlDefinition def) {
        this(os, def, WbXmlEncoder.StrtblType.IF_NEEDED, true, "UTF-8");
    }

    public WbXmlStreamWriter(OutputStream os) {
        this(os, null, WbXmlEncoder.StrtblType.IF_NEEDED, true, "UTF-8");
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        log.fine("writeStartDocument()");
        this.writeStartDocument(this.encoding, null);
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        log.log(Level.FINE, "writeStartDocument({0})", version);
        this.writeStartDocument(this.encoding, null);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        log.log(Level.FINE, "writeStartDocument({0}, {1})", new Object[]{encoding, version});
        if (encoding == null) {
            encoding = this.encoding;
        }
        this.doc = new WbXmlDocument(WbXmlVersion.VERSION_1_3, IanaCharset.getIanaCharset(encoding));
        if (this.def != null) {
            log.log(Level.FINE, "Setting definition {0}", this.def.getName());
            this.doc.setDefinition(this.def);
        }
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeStartElement(null, localName, null);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement(null, localName, namespaceURI);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        ElementContext parent;
        log.log(Level.FINE, "writeStartElement({0}, {1}, {2})", new Object[]{prefix, localName, namespaceURI});
        if (this.def == null) {
            this.def = WbXmlInitialization.getDefinitionByRoot(localName, namespaceURI);
            if (this.def == null) {
                throw new XMLStreamException(String.format("Definition not found for root element '%s'", localName));
            }
            log.log(Level.FINE, "Setting definition {0}", this.def.getName());
            this.doc.setDefinition(this.def);
        }
        if ((parent = new ElementContext(this.current)).getElement() == null) {
            parent = this.parents.peek();
        } else {
            this.parents.push(parent);
        }
        int idx = localName.indexOf(58);
        if (idx >= 0) {
            prefix = localName.substring(0, idx);
            localName = localName.substring(idx + 1);
        }
        if (prefix != null && !prefix.isEmpty()) {
            localName = prefix + ":" + localName;
        }
        this.current.setElement(new WbXmlElement(localName));
        if (parent != null && parent.getElement() != null) {
            parent.getElement().addContent(new WbXmlContent(this.current.getElement()));
        } else {
            if (this.doc.getBody() != null) {
                throw new XMLStreamException(String.format("Trying to add a second root element '%s'", localName));
            }
            this.doc.setBody(new WbXmlBody(this.current.getElement()));
        }
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeEmptyElement(null, localName, null);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeEmptyElement(null, localName, null);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        log.log(Level.FINE, "writeEmptyElement({0}, {1}, {2})", new Object[]{prefix, localName, namespaceURI});
        this.calculateAndNextTag();
    }

    private void calculateAndNextTag() {
        String localName = this.current.getElement().getTag();
        String prefix = null;
        String namespaceURI = this.current.getNamespace();
        int idx = localName.indexOf(58);
        if (idx >= 0) {
            prefix = localName.substring(0, idx);
            localName = localName.substring(idx + 1);
        }
        if (namespaceURI != null && !namespaceURI.isEmpty()) {
            prefix = this.def.getPrefixWithLinked(namespaceURI);
        } else if (prefix != null && !prefix.isEmpty()) {
            namespaceURI = this.current.getContext().getNamespaceURI(prefix);
            if (namespaceURI != null) {
                prefix = this.def.getPrefixWithLinked(namespaceURI);
            }
        } else if (this.current.getContext().isDefaultNamespaceDefined()) {
            prefix = this.def.getPrefixWithLinked(this.current.getContext().getDefaultNamespace());
        }
        if (prefix != null && !prefix.isEmpty()) {
            localName = prefix + ":" + localName;
        }
        this.current.getElement().setTag(localName);
        this.current = this.parents.isEmpty() ? new ElementContext() : this.parents.pop();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        log.log(Level.FINE, "writeEndElement()");
        this.calculateAndNextTag();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        log.log(Level.FINE, "writeEndDocument()");
        while (this.current.getElement() != null) {
            this.writeEndElement();
        }
        try {
            WbXmlEncoder encoder = new WbXmlEncoder(this.stream, this.doc, this.encoderType);
            encoder.encode();
            this.encoded = true;
        }
        catch (IOException e) {
            throw new XMLStreamException("Error encoding the WbXML document", e);
        }
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public void flush() throws XMLStreamException {
        try {
            log.log(Level.FINE, "flush()");
            if (this.encoded) {
                this.stream.flush();
            }
        }
        catch (IOException e) {
            throw new XMLStreamException("Error flushing the stream", e);
        }
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writeAttribute(null, null, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writeAttribute(null, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        log.log(Level.FINE, "writeAttribute({0}, {1}, {2}, {3})", new Object[]{prefix, namespaceURI, localName, value});
        int idx = localName.indexOf(58);
        if (idx >= 0) {
            prefix = localName.substring(0, idx);
            localName = localName.substring(idx + 1);
        }
        if (namespaceURI != null && !namespaceURI.isEmpty()) {
            prefix = this.def.getPrefixWithLinked(namespaceURI);
        } else if (prefix != null && !prefix.isEmpty()) {
            namespaceURI = this.current.getContext().getNamespaceURI(prefix);
            if (namespaceURI != null) {
                prefix = this.def.getPrefixWithLinked(namespaceURI);
            }
        } else if (this.current.getContext().isDefaultNamespaceDefined()) {
            prefix = this.def.getPrefix(this.current.getContext().getDefaultNamespace());
        }
        if (prefix != null && !prefix.isEmpty()) {
            localName = prefix + ":" + localName;
        }
        if (this.current.getElement() == null) {
            throw new XMLStreamException(String.format("No elemento to add the attribute '%s'='%s' to", localName, value));
        }
        this.current.getElement().addAttribute(new WbXmlAttribute(localName, value));
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        log.log(Level.FINE, "writeNamespace({0}, {1})", new Object[]{prefix, namespaceURI});
        if (namespaceURI == null || namespaceURI.isEmpty()) {
            return;
        }
        if (prefix == null || prefix.isEmpty() || prefix.equals("xmlns")) {
            if (this.current.getElement() != null) {
                this.current.setContext(this.current.getContext().clone());
                this.current.getContext().setDefaultNamespace(namespaceURI);
            }
        } else {
            if (this.def.getPrefixWithLinked(namespaceURI) == null) {
                throw new XMLStreamException(String.format("namespaceURI '%s' is not defined in the WbXML definition", namespaceURI));
            }
            this.current.setContext(this.current.getContext().clone());
            this.current.getContext().addPrefix(prefix, namespaceURI);
        }
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        log.log(Level.FINE, "writeDefaultNamespace({0})", namespaceURI);
        this.writeNamespace("xmlns", namespaceURI);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        log.log(Level.FINE, "writeComment({0})", data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        log.log(Level.FINE, "writeCData({0})", data);
        this.writeCharsInternal(data, false);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        log.log(Level.FINE, "writeDTD({0})", dtd);
        if (this.def == null) {
            int idxRoot = dtd.indexOf("<!DOCTYPE ") + 10;
            int idxEndRoot = dtd.indexOf(32, idxRoot);
            int idxFPI = dtd.indexOf(34, idxEndRoot + 1) + 1;
            int idxEndFPI = dtd.indexOf(34, idxFPI);
            if (idxRoot > 0 && idxEndRoot > idxRoot && idxFPI > idxEndRoot && idxEndFPI > idxFPI) {
                String root = dtd.substring(idxRoot, idxEndRoot).trim();
                String fpi = dtd.substring(idxFPI, idxEndFPI);
                this.def = WbXmlInitialization.getDefinitionByFPI(fpi);
                log.log(Level.FINE, "FPI: {0}", this.def.getName());
                if (this.def == null) {
                    this.def = WbXmlInitialization.getDefinitionByRoot(root, null);
                    log.log(Level.FINE, "root: {0}", this.def.getName());
                }
                if (this.def != null) {
                    this.doc.setDefinition(this.def);
                }
            }
        }
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static char[] skipWhitespacesPrefix(char[] data) {
        int i = 0;
        while (i < data.length) {
            if (!XMLChar.isSpace(data[i])) {
                if (i == 0) {
                    return data;
                }
                return Arrays.copyOfRange(data, i, data.length);
            }
            ++i;
        }
        return new char[0];
    }

    private static char[] skipWhitespacesSuffix(char[] data) {
        int i = data.length - 1;
        while (i >= 0) {
            if (!XMLChar.isSpace(data[i])) {
                if (i == data.length - 1) {
                    return data;
                }
                return Arrays.copyOfRange(data, 0, i + 1);
            }
            --i;
        }
        return new char[0];
    }

    private static char[] skipWhitespaces(char[] data) {
        data = WbXmlStreamWriter.skipWhitespacesPrefix(data);
        data = WbXmlStreamWriter.skipWhitespacesSuffix(data);
        return data;
    }

    private void writeCharsInternal(String text, boolean skip) {
        log.log(Level.FINE, "writeCharsInternal({0})", text);
        if (this.current.getElement() != null) {
            if (skip) {
                if (!(text = new String(WbXmlStreamWriter.skipWhitespaces(text.toCharArray()))).isEmpty()) {
                    this.current.getElement().addContent(new WbXmlContent(text));
                } else {
                    log.log(Level.FINE, "Skipping characters {0}", text);
                }
            } else {
                this.current.getElement().addContent(new WbXmlContent(text));
            }
        }
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        log.log(Level.FINE, "writeCharacters({0})", text);
        this.writeCharsInternal(text, this.skipSpaces);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        log.log(Level.FINE, "writeCharacters({0}, {1}, {2})", new Object[]{text, start, len});
        this.writeCharsInternal(new String(text, start, len), this.skipSpaces);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        log.log(Level.FINE, "getPrefix({0})", uri);
        String res = this.current.getContext().getPrefix(uri);
        if (res == null && this.userctx != null) {
            res = this.userctx.getPrefix(uri);
        }
        return res;
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        log.log(Level.FINE, "setPrefix({0}, {1})", new Object[]{prefix, uri});
        if (prefix == null) {
            throw new XMLStreamException("Prefix cannot be null");
        }
        if (uri == null) {
            throw new XMLStreamException("URI cannot be null");
        }
        this.current.setContext(this.current.getContext().clone());
        this.current.getContext().addPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String namespaceURI) throws XMLStreamException {
        log.log(Level.FINE, "setDefaultNamespace({0})", namespaceURI);
        this.current.setContext(this.current.getContext().clone());
        this.current.getContext().setDefaultNamespace(namespaceURI);
    }

    @Override
    public void setNamespaceContext(NamespaceContext nc) throws XMLStreamException {
        log.log(Level.FINE, "setNamespaceContext({0})", nc);
        this.userctx = nc;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        log.fine("getNamespaceContext()");
        return this.current.getContext();
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class ElementContext {
        private String namespace;
        private WbXmlElement element;
        private WbXmlNamespaceContext nsctx;

        public ElementContext() {
            this.namespace = null;
            this.element = null;
            this.nsctx = null;
        }

        public ElementContext(ElementContext e) {
            this.namespace = e.namespace;
            this.element = e.element;
            this.nsctx = e.nsctx;
        }

        public ElementContext(WbXmlElement element, String namespace, WbXmlNamespaceContext nsctx) {
            this.element = element;
            this.nsctx = nsctx;
            this.namespace = namespace;
        }

        public WbXmlElement getElement() {
            return this.element;
        }

        public void setElement(WbXmlElement element) {
            this.element = element;
        }

        public WbXmlNamespaceContext getContext() {
            return this.nsctx;
        }

        public void setContext(WbXmlNamespaceContext nsctx) {
            this.nsctx = nsctx;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }
    }
}

