/*
 * Decompiled with CFR 0.152.
 */
package org.marre.mime;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.marre.mime.MimeContentType;
import org.marre.mime.MimeHeader;

public class MimeBodyPart {
    protected byte[] body_;
    protected MimeContentType contentType_;
    protected final List<MimeHeader> headers_ = new LinkedList<MimeHeader>();

    public MimeBodyPart() {
    }

    public MimeBodyPart(byte[] body, MimeContentType contentType) {
        this();
        this.setContent(body, contentType);
    }

    public MimeBodyPart(byte[] body, String contentType) {
        this();
        this.setContent(body, contentType);
    }

    public void addHeader(MimeHeader header) {
        this.headers_.add(header);
    }

    public void addHeader(String headerName, String headerValue) {
        MimeHeader header = this.getHeader(headerName);
        if (header != null) {
            this.headers_.remove(header);
        }
        this.addHeader(new MimeHeader(headerName, headerValue));
    }

    public Collection<MimeHeader> getHeaders() {
        return Collections.unmodifiableCollection(this.headers_);
    }

    public MimeHeader getHeader(String headerName) {
        for (MimeHeader header : this.headers_) {
            if (!header.getName().equalsIgnoreCase(headerName)) continue;
            return header;
        }
        return null;
    }

    public void setContent(byte[] content, String contentType) {
        this.body_ = new byte[content.length];
        System.arraycopy(content, 0, this.body_, 0, content.length);
        this.contentType_ = new MimeContentType(contentType);
    }

    public void setContent(byte[] content, MimeContentType contentType) {
        this.body_ = new byte[content.length];
        System.arraycopy(content, 0, this.body_, 0, content.length);
        this.contentType_ = contentType;
    }

    public void setContentId(String contentId) {
        this.addHeader("Content-Id", contentId);
    }

    public void setContentLocation(String contentLocation) {
        this.addHeader("Content-Location", contentLocation);
    }

    public byte[] getBody() {
        byte[] bodyCopy = null;
        if (this.body_ != null) {
            bodyCopy = new byte[this.body_.length];
            System.arraycopy(this.body_, 0, bodyCopy, 0, this.body_.length);
        }
        return bodyCopy;
    }

    public int getBodySize() {
        return this.body_.length;
    }

    public MimeContentType getContentType() {
        return this.contentType_;
    }
}

