/*
 * Decompiled with CFR 0.152.
 */
package org.marre.mime;

import com.zx.sms.common.util.StandardCharsets;
import org.marre.mime.MimeBodyPart;
import org.marre.mime.MimeContentType;

public final class MimeFactory {
    private MimeFactory() {
    }

    public static MimeBodyPart createTextBodyPart(String str) {
        return MimeFactory.createTextBodyPart(str, "text/plain");
    }

    public static MimeBodyPart createTextBodyPart(String str, String contentType) {
        MimeBodyPart textBodyPart = new MimeBodyPart();
        MimeContentType ct = new MimeContentType(contentType);
        ct.setParam("charset", "utf-8");
        byte[] data = str.getBytes(StandardCharsets.UTF_8);
        textBodyPart.setContent(data, ct);
        return textBodyPart;
    }

    public static MimeBodyPart createBinaryBodyPart(byte[] content, String contentType) {
        MimeBodyPart binBodyPart = new MimeBodyPart();
        binBodyPart.setContent(content, contentType);
        return binBodyPart;
    }
}

