/*
 * Decompiled with CFR 0.152.
 */
package org.marre.mime;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.marre.mime.MimeHeaderParameter;

public class MimeHeader {
    protected final String headerName_;
    protected String headerValue_;
    protected final List<MimeHeaderParameter> params_ = new LinkedList<MimeHeaderParameter>();

    public MimeHeader(String name, String value) {
        this.headerName_ = name;
        this.headerValue_ = value;
    }

    public void setValue(String theValue) {
        this.headerValue_ = theValue;
    }

    public String getName() {
        return this.headerName_;
    }

    public String getValue() {
        return this.headerValue_;
    }

    public void setParam(String theName, String theValue) {
        this.removeParameter(theName);
        this.params_.add(new MimeHeaderParameter(theName, theValue));
    }

    public MimeHeaderParameter getParameter(String theName) {
        for (MimeHeaderParameter param : this.params_) {
            if (!param.getName().equalsIgnoreCase(theName)) continue;
            return param;
        }
        return null;
    }

    public void removeParameter(String theName) {
        MimeHeaderParameter param = this.getParameter(theName);
        if (param != null) {
            this.params_.remove(param);
        }
    }

    public Collection<MimeHeaderParameter> getParameters() {
        return Collections.unmodifiableCollection(this.params_);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.headerName_).append("=").append(this.headerValue_);
        for (MimeHeaderParameter param : this.params_) {
            sb.append("; ").append(param.getName()).append("=").append(param.getValue());
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MimeHeader)) {
            return false;
        }
        MimeHeader that = (MimeHeader)o;
        if (!this.headerName_.equals(that.headerName_)) {
            return false;
        }
        if (!this.headerValue_.equals(that.headerValue_)) {
            return false;
        }
        return this.params_.equals(that.params_);
    }

    public int hashCode() {
        int result = this.headerName_.hashCode();
        result = 31 * result + this.headerValue_.hashCode();
        result = 31 * result + this.params_.hashCode();
        return result;
    }
}

